/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.awt.event.ItemEvent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;

public class ConfigToggleButtonModel
extends JToggleButton.ToggleButtonModel
implements ValueProviderListener<Boolean> {
    private static final long serialVersionUID = -3517910678740645735L;
    private final ValueProvider<Boolean> provider;

    public ConfigToggleButtonModel(ValueProvider<Boolean> provider) {
        this.provider = provider;
        provider.register(this, true);
        super.setSelected(this.isSelected());
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                return (Boolean)ConfigToggleButtonModel.this.provider.get();
            }
        }.getReturnValue());
    }

    @Override
    public void setSelected(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigToggleButtonModel.this.provider.set(b);
            }
        });
    }

    private void fireItemStateChanged(boolean selected) {
        this.fireItemStateChanged(new ItemEvent(this, 701, this, selected ? 1 : 2));
    }

    @Override
    public void onValueModified(ValueProvider<Boolean> owner, final Boolean newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigToggleButtonModel.this.fireStateChanged();
                ConfigToggleButtonModel.this.fireItemStateChanged(Boolean.TRUE.equals(newValue));
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Boolean> owner, Boolean invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigToggleButtonModel.this.fireStateChanged();
                ConfigToggleButtonModel.this.fireItemStateChanged(ConfigToggleButtonModel.this.isSelected());
            }
        };
    }
}

