/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.util.List;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.LongKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.swing.EDTRunner;

public class ConfigLongSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Long> {
    private static final long serialVersionUID = 1L;
    private final ValueProvider<Long> provider;

    public ConfigLongSpinnerModel(LongKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Long>(keyHandler));
    }

    public ConfigLongSpinnerModel(ValueProvider<Long> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<SpinnerValidator> spinn = provider.getAnnotations(SpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Long.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Long.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Long.valueOf(((Number)((Object)minimum)).longValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Long.valueOf(((Number)((Object)maximum)).longValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.longValue());
    }

    @Override
    public Number getNumber() {
        return this.provider.get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    protected Number incrValue(int i) {
        return ConfigIntSpinnerModel.incrValue(this, Byte.class, i);
    }

    @Override
    public Object getValue() {
        return this.provider.get();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof Number) {
                this.provider.set(((Number)value).longValue());
            } else if (value instanceof String && ((String)value).matches("^-?\\d+$")) {
                this.provider.set(Long.valueOf(String.valueOf(value)));
            }
        }
        catch (ValidationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    @Override
    public void onValueModified(ValueProvider<Long> owner, Long newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigLongSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Long> owner, Long invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigLongSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

