/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class StringKeyHandler
extends KeyHandler<String> {
    public StringKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    public String getValue() {
        return (String)super.getValue();
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultStringValue.class;
    }

    @Override
    protected void initHandler() throws Throwable {
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(String object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof String && y instanceof String) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    protected void validateValue(String object) throws Throwable {
    }
}

