/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class EnumKeyHandler
extends KeyHandler<Enum> {
    public EnumKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultEnumValue.class;
    }

    @Override
    public Enum getDefaultValue() {
        if (this.getDefaultFactoryAnnotation() != null) {
            return this.readDefaultValue();
        }
        return (Enum)this.accessDefaultValue();
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Enum && y instanceof Enum) {
            return x.equals(y);
        }
        return false;
    }

    protected Enum readDefaultValue() {
        try {
            DefaultFactory df = this.getDefaultFactoryAnnotation();
            if (df != null) {
                AbstractDefaultFactory<?> defaultFactory = df.value().newInstance();
                Enum defaultValue = defaultFactory.getDefaultValue(this);
                defaultValue = (Enum)this.storageHandler.runDefaultValueFactory(this, defaultValue);
                defaultValue = this.applyCustomValueGetter(defaultValue);
                return defaultValue;
            }
            if (this.isFactoryDefaultValueSet()) {
                Enum defaultValue = (Enum)this.accessDefaultValue();
                return defaultValue;
            }
            DefaultJsonObject defaultJson = this.getAnnotation(DefaultJsonObject.class);
            if (defaultJson != null) {
                Enum defaultValue = JSonStorage.restoreFromString(defaultJson.value(), new TypeRef<Enum>(this.getRawClass()){}, null);
                defaultValue = (Enum)this.storageHandler.runDefaultValueFactory(this, defaultValue);
                defaultValue = this.applyCustomValueGetter(defaultValue);
                this.setFactoryDefaultValue(defaultValue);
                return defaultValue;
            }
            DefaultEnumValue ann = this.getAnnotation(DefaultEnumValue.class);
            if (ann != null) {
                try {
                    Object defaultValue = Enum.valueOf(this.getRawClass(), ann.value());
                    defaultValue = (Enum)this.storageHandler.runDefaultValueFactory(this, defaultValue);
                    defaultValue = (Enum)this.applyCustomValueGetter(defaultValue);
                    this.setFactoryDefaultValue(defaultValue);
                    return defaultValue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            Enum defaultValue = ((Enum[])this.getRawClass().getEnumConstants())[0];
            defaultValue = (Enum)this.storageHandler.runDefaultValueFactory(this, defaultValue);
            defaultValue = this.applyCustomValueGetter(defaultValue);
            this.setFactoryDefaultValue(defaultValue);
            return defaultValue;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Enum[] values() {
        ArrayList<Enum> ret = new ArrayList<Enum>();
        for (Enum e : (Enum[])this.getRawClass().getEnumConstants()) {
            ret.add(e);
        }
        return ret.toArray(new Enum[0]);
    }

    @Override
    protected void initDefaults() throws Throwable {
        Enum defaultValue = this.readDefaultValue();
        this.setDefaultValue(defaultValue);
    }

    @Override
    protected void initHandler() throws Throwable {
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(Enum object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Enum object) throws Throwable {
    }
}

