/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.CustomStorageName;
import org.appwork.storage.config.annotations.StorageHandlerFactoryAnnotation;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;

public class JsonConfig {
    private static final HashMap<String, ConfigInterface> CACHE = new HashMap();
    private static final HashMap<String, LockObject> LOCKS = new HashMap();

    public static <T extends ConfigInterface> String getStorageName(Class<T> configInterface) {
        String id = configInterface.getName();
        CustomStorageName anno = configInterface.getAnnotation(CustomStorageName.class);
        if (anno != null) {
            id = anno.value();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ConfigInterface> T create(Class<T> configInterface) {
        LockObject lock;
        String path = JsonConfig.getStorageName(configInterface);
        HashMap<String, ConfigInterface> hashMap = CACHE;
        synchronized (hashMap) {
            ConfigInterface ret = CACHE.get(path);
            if (ret != null) {
                return (T)ret;
            }
        }
        LockObject lockObject = lock = JsonConfig.requestLock(path);
        synchronized (lockObject) {
            try {
                ConfigInterface ret;
                HashMap<String, ConfigInterface> hashMap2 = CACHE;
                synchronized (hashMap2) {
                    ret = CACHE.get(path);
                    if (ret != null) {
                        ConfigInterface configInterface2 = ret;
                        return (T)configInterface2;
                    }
                }
                ClassLoader cl = configInterface.getClassLoader();
                if (lock.getStorageHandler() == null) {
                    StorageHandlerFactoryAnnotation factoryClass = configInterface.getAnnotation(StorageHandlerFactoryAnnotation.class);
                    File f = Application.getResource("cfg/" + path);
                    if (factoryClass != null) {
                        lock.setStorageHandler(factoryClass.value().newInstance().create(f, configInterface));
                    } else {
                        lock.setStorageHandler(new StorageHandler<T>(f, configInterface));
                    }
                }
                ret = (ConfigInterface)Proxy.newProxyInstance(cl, new Class[]{configInterface}, (InvocationHandler)lock.getStorageHandler());
                Object object = CACHE;
                synchronized (object) {
                    if (lock.getLock().get() == 1) {
                        CACHE.put(path, ret);
                    }
                }
                object = ret;
                return (T)object;
            }
            catch (Throwable e) {
                LogV3.defaultLogger().log(e);
                if (!(e instanceof RuntimeException)) throw new WTFException(e);
                throw (RuntimeException)e;
            }
            finally {
                JsonConfig.unLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ConfigInterface> T put(String path, Class<T> configInterface, StorageHandler<T> storageHandler) {
        LockObject lock;
        LockObject lockObject = lock = JsonConfig.requestLock(path);
        synchronized (lockObject) {
            try {
                ClassLoader cl = configInterface.getClassLoader();
                lock.setStorageHandler(storageHandler);
                ConfigInterface ret = (ConfigInterface)Proxy.newProxyInstance(cl, new Class[]{configInterface}, storageHandler);
                Object object = CACHE;
                synchronized (object) {
                    if (lock.getLock().get() == 1) {
                        if (CACHE.containsKey(path)) {
                            throw new IllegalStateException("Path is already initialized: " + path);
                        }
                        CACHE.put(path, ret);
                    }
                }
                object = ret;
                return (T)object;
            }
            catch (Throwable e) {
                LogV3.defaultLogger().log(e);
                if (!(e instanceof RuntimeException)) throw new WTFException(e);
                throw (RuntimeException)e;
            }
            finally {
                JsonConfig.unLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ConfigInterface> T create(File path, Class<T> configInterface) {
        LockObject lock;
        String id = path.getAbsolutePath() + JsonConfig.getStorageName(configInterface);
        HashMap<String, ConfigInterface> hashMap = CACHE;
        synchronized (hashMap) {
            ConfigInterface ret = CACHE.get(id);
            if (ret != null) {
                return (T)ret;
            }
        }
        LockObject lockObject = lock = JsonConfig.requestLock(id);
        synchronized (lockObject) {
            try {
                ConfigInterface ret;
                HashMap<String, ConfigInterface> hashMap2 = CACHE;
                synchronized (hashMap2) {
                    ret = CACHE.get(id);
                    if (ret != null) {
                        ConfigInterface configInterface2 = ret;
                        return (T)configInterface2;
                    }
                }
                ClassLoader cl = configInterface.getClassLoader();
                if (lock.getStorageHandler() == null) {
                    StorageHandlerFactoryAnnotation factoryClass = configInterface.getAnnotation(StorageHandlerFactoryAnnotation.class);
                    if (factoryClass != null) {
                        lock.setStorageHandler(factoryClass.value().newInstance().create(path, configInterface));
                    } else {
                        lock.setStorageHandler(new StorageHandler<T>(path, configInterface));
                    }
                }
                ret = (ConfigInterface)Proxy.newProxyInstance(cl, new Class[]{configInterface}, (InvocationHandler)lock.getStorageHandler());
                Object object = CACHE;
                synchronized (object) {
                    if (lock.getLock().get() == 1) {
                        CACHE.put(id, ret);
                    }
                }
                object = ret;
                return (T)object;
            }
            catch (Throwable e) {
                LogV3.defaultLogger().log(e);
                if (!(e instanceof RuntimeException)) throw new WTFException(e);
                throw (RuntimeException)e;
            }
            finally {
                JsonConfig.unLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ConfigInterface> T create(String urlPath, Class<T> configInterface) {
        LockObject lock;
        String id = urlPath + JsonConfig.getStorageName(configInterface);
        HashMap<String, ConfigInterface> hashMap = CACHE;
        synchronized (hashMap) {
            ConfigInterface ret = CACHE.get(id);
            if (ret != null) {
                return (T)ret;
            }
        }
        LockObject lockObject = lock = JsonConfig.requestLock(id);
        synchronized (lockObject) {
            try {
                ConfigInterface ret;
                HashMap<String, ConfigInterface> hashMap2 = CACHE;
                synchronized (hashMap2) {
                    ret = CACHE.get(id);
                    if (ret != null) {
                        ConfigInterface configInterface2 = ret;
                        return (T)configInterface2;
                    }
                }
                ClassLoader cl = configInterface.getClassLoader();
                if (lock.getStorageHandler() == null) {
                    StorageHandlerFactoryAnnotation factoryClass = configInterface.getAnnotation(StorageHandlerFactoryAnnotation.class);
                    if (factoryClass != null) {
                        lock.setStorageHandler(factoryClass.value().newInstance().create(urlPath, configInterface));
                    } else {
                        lock.setStorageHandler(new StorageHandler<T>(urlPath, configInterface));
                    }
                }
                ret = (ConfigInterface)Proxy.newProxyInstance(cl, new Class[]{configInterface}, (InvocationHandler)lock.getStorageHandler());
                Object object = CACHE;
                synchronized (object) {
                    if (lock.getLock().get() == 1) {
                        CACHE.put(id, ret);
                    }
                }
                object = ret;
                return (T)object;
            }
            catch (Throwable e) {
                LogV3.defaultLogger().log(e);
                if (!(e instanceof RuntimeException)) throw new WTFException(e);
                throw (RuntimeException)e;
            }
            finally {
                JsonConfig.unLock(lock);
            }
        }
    }

    public static HashMap<String, ConfigInterface> getCache() {
        return CACHE;
    }

    private static synchronized LockObject requestLock(String id) {
        LockObject lockObject = LOCKS.get(id);
        if (lockObject == null) {
            lockObject = new LockObject(id);
            LOCKS.put(id, lockObject);
        }
        lockObject.getLock().incrementAndGet();
        return lockObject;
    }

    private static synchronized void unLock(LockObject lock) {
        LockObject lockObject = LOCKS.get(lock.getId());
        if (lockObject != null && lockObject.getLock().decrementAndGet() == 0) {
            LOCKS.remove(lock.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFromCache(ConfigInterface config) {
        HashMap<String, ConfigInterface> hashMap = CACHE;
        synchronized (hashMap) {
            HashSet<String> removedKeys = new HashSet<String>();
            for (Map.Entry<String, ConfigInterface> c : CACHE.entrySet()) {
                if (c.getValue() != config) continue;
                removedKeys.add(c.getKey());
            }
            StorageHandler<?> storageHandler = config._getStorageHandler();
            if (storageHandler != null) {
                StorageHandler.clearFromCache(storageHandler);
            }
            for (String key : removedKeys) {
                CACHE.remove(key);
            }
        }
    }

    private static class LockObject {
        private final String id;
        private final AtomicInteger lock = new AtomicInteger(0);
        private StorageHandler storageHandler = null;

        private LockObject(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public AtomicInteger getLock() {
            return this.lock;
        }

        public StorageHandler getStorageHandler() {
            return this.storageHandler;
        }

        public void setStorageHandler(StorageHandler storageHandler) {
            this.storageHandler = storageHandler;
        }
    }
}

