/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.appwork.storage.simplejson.JSonArray;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JSonValue;
import org.appwork.storage.simplejson.JsonObjectLinkedHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Xml2Json {
    private List keyPaths = new ArrayList();
    private Map pathMaps = new HashMap();
    private List repeatables = new ArrayList();
    private List singles = new ArrayList();
    private List skips = new ArrayList();
    private List arrays = new ArrayList();
    private Map namespaceResolvers = new HashMap();
    private String basePath;

    public static String XML2JSON(String xml) throws Exception {
        String ret = new Xml2Json().xml2json(xml);
        return ret;
    }

    public static void main(String[] args) {
        String xml = "<breakfast_menu aa=\"1\" ab=\"0.9\" ac=\"bla\">\n<food>\n<name>Belgian Waffles</name>\n<price>$5.95</price>\n<description>\nTwo of our famous Belgian Waffles with plenty of real maple syrup\n</description>\n<calories>650</calories>\n</food>\n<food>\n<name>Strawberry Belgian Waffles</name>\n<price>$7.95</price>\n<description>\nLight Belgian waffles covered with strawberries and whipped cream\n</description>\n<calories>900</calories>\n</food>\n</breakfast_menu>";
        try {
            Xml2Json xmler = new Xml2Json();
            System.out.println(xmler.xml2json(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPathRule(String xpath, String keyAttrName, boolean isRepeatable, boolean isSingle) {
        if (keyAttrName != null) {
            this.keyPaths.add(xpath);
            this.pathMaps.put(xpath, keyAttrName);
        }
        if (isRepeatable) {
            this.repeatables.add(xpath);
        }
        if (isSingle) {
            this.singles.add(xpath);
        }
    }

    public void addSkipRule(String xpath) {
        this.skips.add(xpath);
    }

    public void addArrayPath(String xpath) {
        this.arrays.add(xpath);
    }

    public void addNamespaceResolver(String prefix, String uri) {
        this.namespaceResolvers.put(uri, prefix);
    }

    public JSonObject xml2jsonObj(NodeList nodes) throws Exception {
        this.basePath = null;
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        Node baseNode = nodes.item(0).getParentNode();
        if (baseNode == null) {
            return null;
        }
        this.basePath = this.getXPath((Element)baseNode);
        JsonObjectLinkedHashMap json = new JsonObjectLinkedHashMap();
        this.nodelist2json(json, nodes);
        return json;
    }

    public JSonObject xml2jsonObj(Element element) throws Exception {
        this.basePath = null;
        Node baseNode = element.getParentNode();
        if (baseNode != null && baseNode.getNodeType() == 1) {
            this.basePath = this.getXPath((Element)baseNode);
        }
        JSonObject obj = (JSonObject)this.node2json(element);
        JsonObjectLinkedHashMap ret = new JsonObjectLinkedHashMap();
        ret.put(element.getNodeName(), obj);
        return ret;
    }

    public String xml2json(NodeList nodes) throws Exception {
        JSonObject obj = this.xml2jsonObj(nodes);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public String xml2json(Element element) throws Exception {
        JSonObject obj = this.xml2jsonObj(element);
        return obj.toString();
    }

    public String xml2json(String xml) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }
        });
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        Element root = doc.getDocumentElement();
        return this.xml2json(root);
    }

    private JSonNode node2json(Element element) throws Exception {
        JsonObjectLinkedHashMap json = new JsonObjectLinkedHashMap();
        String xpath = this.getXPath(element);
        if (this.singles.contains(xpath)) {
            if (element.getFirstChild() != null) {
                return this.text(element.getFirstChild().getNodeValue());
            }
            return new JSonValue("");
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            json.put(name, new JSonValue(value));
        }
        NodeList childs = element.getChildNodes();
        this.nodelist2json(json, childs);
        if (json.size() == 1) {
            return (JSonNode)json.entrySet().iterator().next().getValue();
        }
        return json;
    }

    private JSonValue text(String nodeValue) {
        try {
            return new JSonValue(Long.parseLong(nodeValue));
        }
        catch (Throwable throwable) {
            try {
                return new JSonValue(Double.parseDouble(nodeValue));
            }
            catch (Throwable throwable2) {
                if ("true".equalsIgnoreCase(nodeValue.trim())) {
                    return new JSonValue(true);
                }
                if ("false".equalsIgnoreCase(nodeValue.trim())) {
                    return new JSonValue(true);
                }
                return new JSonValue(nodeValue);
            }
        }
    }

    private void nodelist2json(JSonObject map, NodeList nodes) throws Exception {
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    String text = node.getNodeValue().trim();
                    if (text.length() <= 0) continue block4;
                    map.put("content", this.text(node.getNodeValue()));
                    continue block4;
                }
                case 1: {
                    Element childElm = (Element)node;
                    String childXPath = this.getXPath(childElm);
                    if (this.skips.contains(childXPath)) {
                        this.nodelist2json(map, childElm.getChildNodes());
                        continue block4;
                    }
                    if (this.arrays.contains(childXPath)) {
                        JSonArray obj = (JSonArray)map.get(childElm.getNodeName());
                        if (obj == null) {
                            obj = new JSonArray();
                            map.put(childElm.getNodeName(), obj);
                        }
                        JSonArray array = new JSonArray();
                        NodeList childNodes = childElm.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node child = childNodes.item(j);
                            if (child.getNodeType() != 1) continue;
                            array.add(this.node2json((Element)child));
                        }
                        obj.add(array);
                        continue block4;
                    }
                    String childName = childElm.getNodeName();
                    boolean isRepeatable = this.repeatables.contains(childXPath);
                    boolean hasKey = this.keyPaths.contains(childXPath);
                    if (isRepeatable && hasKey) {
                        JSonObject obj = (JSonObject)map.get(childName);
                        if (obj == null) {
                            obj = new JsonObjectLinkedHashMap();
                            map.put(childName, obj);
                        }
                        String attrName = (String)this.pathMaps.get(childXPath);
                        String attrValue = childElm.getAttribute(attrName);
                        obj.put(attrValue, this.node2json(childElm));
                        continue block4;
                    }
                    if (isRepeatable && !hasKey) {
                        JSonArray obj = (JSonArray)map.get(childName);
                        if (obj == null) {
                            obj = new JSonArray();
                            map.put(childName, obj);
                        }
                        obj.add(this.node2json(childElm));
                        continue block4;
                    }
                    if (hasKey) {
                        String attrName = (String)this.pathMaps.get(childXPath);
                        String attrValue = childElm.getAttribute(attrName);
                        map.put(attrValue, this.node2json(childElm));
                        continue block4;
                    }
                    map.put(childName, this.node2json(childElm));
                    continue block4;
                }
            }
        }
    }

    private String getXPath(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer xpath = new StringBuffer();
        xpath.append("/");
        String uri = element.getNamespaceURI();
        String prefix = (String)this.namespaceResolvers.get(uri);
        if (prefix != null) {
            xpath.append(prefix).append(":");
        }
        xpath.append(this.getTagName(element));
        Element parent = element;
        try {
            while ((parent = (Element)parent.getParentNode()) != null) {
                xpath.insert(0, this.getTagName(parent));
                uri = parent.getNamespaceURI();
                prefix = (String)this.namespaceResolvers.get(uri);
                if (prefix != null) {
                    xpath.insert(0, prefix + ":");
                }
                xpath.insert(0, "/");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        String xpathStr = xpath.toString();
        if (this.basePath != null) {
            xpathStr = xpathStr.replaceFirst("^" + this.basePath, "");
        }
        return xpathStr;
    }

    private String getTagName(Element elem) {
        String name = elem.getLocalName();
        if (name == null) {
            name = elem.getNodeName();
        }
        return name;
    }
}

