/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appwork.storage.SimpleTypeRef;

public abstract class TypeRef<T> {
    public static final TypeRef<String> STRING = new SimpleTypeRef<String>((Type)((Object)String.class));
    public static final TypeRef<byte[]> BYTE_ARRAY = new SimpleTypeRef<byte[]>((Type)((Object)byte[].class));
    public static final TypeRef<HashMap<String, Object>> HASHMAP = new TypeRef<HashMap<String, Object>>(){};
    public static final TypeRef<ArrayList<HashMap<String, Object>>> LIST_HASHMAP = new TypeRef<ArrayList<HashMap<String, Object>>>(){};
    public static final TypeRef<Map<String, Object>> MAP = new TypeRef<Map<String, Object>>(){};
    public static final TypeRef<List<Object>> LIST = new TypeRef<List<Object>>(){};
    public static final TypeRef<HashMap<String, String>> HASHMAP_STRING = new TypeRef<HashMap<String, String>>(){};
    public static final TypeRef<Boolean> BOOLEAN = new SimpleTypeRef<Boolean>(Boolean.class){};
    public static final TypeRef<String[]> STRING_ARRAY = new SimpleTypeRef<String[]>((Type)((Object)String[].class));
    public static final TypeRef<Object> OBJECT = new SimpleTypeRef<Object>((Type)((Object)Object.class));
    public static final TypeRef<int[]> INT_ARRAY = new SimpleTypeRef<int[]>((Type)((Object)int[].class));
    public static final TypeRef<HashSet<String>> STRING_HASHSET = new TypeRef<HashSet<String>>(){};
    public static final TypeRef<Set<String>> STRING_SET = new TypeRef<Set<String>>(){};
    public static final TypeRef<Object[]> OBJECT_ARRAY = new SimpleTypeRef<Object[]>((Type)((Object)Object[].class));
    public static final TypeRef<boolean[]> BOOLEAN_ARRAY = new SimpleTypeRef<boolean[]>((Type)((Object)boolean[].class));
    public static final TypeRef<Long> LONG = new SimpleTypeRef<Long>((Type)((Object)Long.class));
    public static final TypeRef<ArrayList<String>> STRING_LIST = new TypeRef<ArrayList<String>>(){};
    private final Type type;
    private final Class<?> rawClass;

    public TypeRef() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Wrong TypeRef Construct");
        }
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawClass = this.initRawClass(this.getType());
    }

    protected Class<?> initRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)type).getRawType();
            if (raw instanceof Class) {
                return (Class)raw;
            }
            return null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeRef) {
            return this.getType().equals(((TypeRef)obj).getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public TypeRef(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = t;
        this.rawClass = this.initRawClass(this.getType());
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }
}

