/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.appwork.storage.CleaningRuntimeException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.GetterSetter;

public class CleanedJSonObject {
    protected Object object;
    private String key;
    private CleanedJSonObject parent;
    private CompareInstanceProvider compareFactory;
    private static final HashMap<Class<?>, Collection<GetterSetter>> GETTER_SETTER_CACHE = new HashMap();

    public CleanedJSonObject setCompareFactory(CompareInstanceProvider compareFactory) {
        this.compareFactory = compareFactory;
        return this;
    }

    public CleanedJSonObject(Object responseData, CompareInstanceProvider compareFactory) {
        this.object = responseData;
        this.compareFactory = compareFactory;
    }

    public CleanedJSonObject(Object responseData) {
        this.object = responseData;
    }

    protected CleanedJSonObject(String key, Object responseData, CleanedJSonObject parent) {
        this.object = responseData;
        this.key = key;
        this.parent = parent;
        this.compareFactory = parent.compareFactory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CleanedJSonObject o = this;
        do {
            if (o.key == null && o.object == null) continue;
            if (sb.length() > 0) {
                sb.insert(0, ".");
            }
            sb.insert(0, o.key == null ? o.object.getClass().getSimpleName() : o.key);
        } while ((o = o.parent) != null);
        return sb.toString();
    }

    public static boolean isBoolean(Type type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isNotEmpty(String ip) {
        return ip != null && ip.trim().length() != 0;
    }

    public static String createKey(String key) {
        StringBuilder sb = new StringBuilder();
        char[] ca = key.toCharArray();
        boolean starter = true;
        for (char element : ca) {
            if (starter && Character.isUpperCase(element)) {
                sb.append(Character.toLowerCase(element));
                continue;
            }
            starter = false;
            sb.append(element);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GetterSetter> getGettersSetteres(Class<?> clazz) {
        HashMap<Class<?>, Collection<GetterSetter>> hashMap = GETTER_SETTER_CACHE;
        synchronized (hashMap) {
            Collection<GetterSetter> ret = GETTER_SETTER_CACHE.get(clazz);
            if (ret != null) {
                return ret;
            }
            Class<?> org = clazz;
            HashMap<Class<?>, Collection<GetterSetter>> hashMap2 = GETTER_SETTER_CACHE;
            synchronized (hashMap2) {
                ret = GETTER_SETTER_CACHE.get(clazz);
                if (ret != null) {
                    return ret;
                }
                HashMap<String, GetterSetter> map = new HashMap<String, GetterSetter>();
                while (clazz != null) {
                    for (Method m : clazz.getDeclaredMethods()) {
                        if (Modifier.isStatic(m.getModifiers())) continue;
                        String key = null;
                        boolean getter = false;
                        if (m.getName().startsWith("is") && CleanedJSonObject.isBoolean(m.getReturnType()) && m.getParameterTypes().length == 0) {
                            key = m.getName().substring(2);
                            getter = true;
                        } else if (m.getName().startsWith("get") && m.getParameterTypes().length == 0) {
                            key = m.getName().substring(3);
                            getter = true;
                        } else if (m.getName().startsWith("set") && m.getParameterTypes().length == 1) {
                            key = m.getName().substring(3);
                            getter = false;
                        }
                        if (!CleanedJSonObject.isNotEmpty(key)) continue;
                        String unmodifiedKey = key;
                        GetterSetter v = (GetterSetter)map.get(key = CleanedJSonObject.createKey(key));
                        if (v == null) {
                            v = new GetterSetter(key);
                            map.put(key, v);
                        }
                        if (getter) {
                            v.setGetter(m);
                        } else {
                            v.setSetter(m);
                        }
                        try {
                            Field field = clazz.getField(unmodifiedKey.substring(0, 1).toLowerCase(Locale.ENGLISH) + unmodifiedKey.substring(1));
                            v.setField(field);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    clazz = this.getSuperClass(clazz);
                }
                GETTER_SETTER_CACHE.put(org, map.values());
                return GETTER_SETTER_CACHE.get(org);
            }
        }
    }

    protected Class<?> getSuperClass(Class<?> clazz) {
        return clazz.getSuperclass();
    }

    public String serialize() {
        Object map = this.getCleanedData();
        return JSonStorage.serializeToJson(map);
    }

    public Object getCleanedData() {
        try {
            if (this.object == null) {
                return null;
            }
            if (this.object instanceof Collection) {
                ArrayList<Object> ret = new ArrayList<Object>();
                int i = 0;
                for (Object o : (Collection)this.object) {
                    ret.add(new CleanedJSonObject("[" + i++ + "]", o, this).getCleanedData());
                }
                return ret;
            }
            if (this.object.getClass().isArray()) {
                ArrayList<Object> ret = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(this.object); ++i) {
                    ret.add(new CleanedJSonObject("[" + i + "]", Array.get(this.object, i), this).getCleanedData());
                }
                return ret;
            }
            if (this.object instanceof Map) {
                HashMap map = new HashMap();
                for (Map.Entry es : ((Map)this.object).entrySet()) {
                    map.put(es.getKey(), new CleanedJSonObject((String)es.getKey(), es.getValue(), this).getCleanedData());
                }
                return map;
            }
            if (this.object instanceof Storable) {
                return this.storableToMap();
            }
            return this.object;
        }
        catch (Exception e) {
            throw new CleaningRuntimeException(e);
        }
    }

    public HashMap<String, Object> storableToMap() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object obj = null;
        Object empty = null;
        if (this.compareFactory != null) {
            empty = this.compareFactory.createInstance(this.object.getClass());
        }
        if (empty == null) {
            Constructor<?> c = this.object.getClass().getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            empty = c.newInstance(new Object[0]);
        }
        for (GetterSetter gs : this.getGettersSetteres(this.object.getClass())) {
            if ("class".equals(gs.getKey()) || CompareUtils.equalsDeep(obj = new CleanedJSonObject(gs.getKey(), gs.get(this.object), this).getCleanedData(), gs.get(empty))) continue;
            map.put(Character.toLowerCase(gs.getKey().charAt(0)) + gs.getKey().substring(1), obj);
        }
        return map;
    }

    public HashMap<String, Object> toMap() {
        try {
            return this.storableToMap();
        }
        catch (NoSuchMethodException e) {
            throw new CleaningRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new CleaningRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new CleaningRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new CleaningRuntimeException(e);
        }
    }

    public static interface CompareInstanceProvider {
        public Object createInstance(Class<? extends Object> var1);
    }
}

