/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.screenshot;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class ScreensShotHelper {
    public static Image getFullScreenShot() throws AWTException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        int xMax = 0;
        int xMin = 0;
        int yMax = 0;
        int yMin = 0;
        for (GraphicsDevice screen : screens) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            xMax = Math.max(xMax, bounds.x + bounds.width);
            yMax = Math.max(bounds.y + bounds.height, yMax);
            yMin = Math.min(yMin, bounds.y);
            xMin = Math.min(xMin, bounds.x);
        }
        BufferedImage complete = null;
        Graphics2D g2 = null;
        BufferedImage img = new BufferedImage(xMax - xMin, yMax - yMin, 1);
        g2 = img.createGraphics();
        complete = img;
        for (GraphicsDevice screen : screens) {
            DisplayMode dm = screen.getDisplayMode();
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            int screenWidth = dm.getWidth();
            int screenHeight = dm.getHeight();
            Rectangle rect = new Rectangle(screenWidth, screenHeight);
            Robot robot = new Robot(screen);
            BufferedImage image = robot.createScreenCapture(rect);
            g2.drawImage((Image)image, bounds.x - xMin, bounds.y - yMin, null);
        }
        g2.dispose();
        g2 = null;
        return img;
    }

    public static Image getScreenShot(int x, int y, int width, int height) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Rectangle rect = new Rectangle(width, height);
        rect.x = x;
        rect.y = y;
        try {
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.ORANGE);
            g2.fillRect(0, 0, width, height);
            for (GraphicsDevice screen : screens) {
                DisplayMode dm = screen.getDisplayMode();
                Rectangle bounds = screen.getDefaultConfiguration().getBounds();
                if (!bounds.intersects(rect)) continue;
                Rectangle part = bounds.intersection(rect);
                part.x -= bounds.x;
                part.y -= bounds.y;
                Robot robot = new Robot(screen);
                BufferedImage image = robot.createScreenCapture(part);
                Rectangle intersections = bounds.intersection(rect);
                g2.drawImage((Image)image, intersections.x - x, intersections.y - y, null);
            }
            g2.dispose();
            return img;
        }
        catch (AWTException e) {
            e.printStackTrace();
            return null;
        }
    }
}

