/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.screenshot;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.VolatileImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JWindow;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class ScreenShooter
extends JWindow
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3184465232251321247L;
    private static final int SIZE = 150;
    private static final int FACTOR = 5;
    private static final int SCALED_SIZE = 30;
    protected static final int FPS = 50;
    private static ScreenShooter layover;
    private Image image;
    private boolean isDragging = false;
    private Point dragStart;
    private Point dragEnd;
    private Image grayedImage;
    private final Rectangle[] bounds;
    private BufferedImage screenshot;
    private final JFrame frame;
    private Point mouse;
    private boolean disposed = false;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;

    public static ScreenShooter create() throws AWTException {
        Image img;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        int xMax = 0;
        int xMin = 0;
        int yMax = 0;
        int yMin = 0;
        for (GraphicsDevice screen : screens) {
            GraphicsDevice[] bounds = screen.getDefaultConfiguration().getBounds();
            xMax = Math.max(xMax, bounds.x + bounds.width);
            yMax = Math.max(bounds.y + bounds.height, yMax);
            yMin = Math.min(yMin, bounds.y);
            xMin = Math.min(xMin, bounds.x);
        }
        Image complete = null;
        Graphics2D g2 = null;
        if (CrossSystem.isUnix()) {
            img = new BufferedImage(xMax - xMin, yMax - yMin, 1);
            g2 = ((BufferedImage)img).createGraphics();
            complete = img;
        } else {
            img = ge.getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(xMax - xMin, yMax - yMin);
            g2 = ((VolatileImage)img).createGraphics();
            complete = img;
        }
        VolatileImage completeGrayed = ge.getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(xMax - xMin, yMax - yMin);
        Graphics2D g2gray = completeGrayed.createGraphics();
        for (GraphicsDevice screen : screens) {
            DisplayMode dm = screen.getDisplayMode();
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            int screenWidth = dm.getWidth();
            int screenHeight = dm.getHeight();
            Rectangle rect = new Rectangle(screenWidth, screenHeight);
            Robot robot = new Robot(screen);
            BufferedImage image = robot.createScreenCapture(rect);
            g2.drawImage((Image)image, bounds.x - xMin, bounds.y - yMin, null);
            g2gray.drawImage((Image)image, bounds.x - xMin, bounds.y - yMin, null);
            Composite comp = g2gray.getComposite();
            g2gray.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2gray.setColor(Color.BLACK);
            g2gray.fillRect(bounds.x - xMin, bounds.y - yMin, screenWidth, screenHeight);
            g2gray.drawImage((Image)image, bounds.x - xMin, bounds.y - yMin, null);
            g2gray.setComposite(comp);
        }
        g2.dispose();
        g2gray.dispose();
        g2 = null;
        g2gray = null;
        ScreenShooter layover = new ScreenShooter(xMin, yMin, xMax, yMax);
        layover.setImage(complete, completeGrayed);
        return layover;
    }

    public static void main(String[] args) throws AWTException, InterruptedException {
        new EDTHelper<ScreenShooter>(){

            @Override
            public ScreenShooter edtRun() {
                try {
                    layover = ScreenShooter.create();
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
                layover.start();
                return null;
            }
        }.waitForEDT();
        BufferedImage screenshot = layover.getScreenshot();
        if (screenshot != null) {
            try {
                Dialog.getInstance().showConfirmDialog(0, "", "", new ImageIcon(screenshot), null, null);
            }
            catch (DialogClosedException e) {
                e.printStackTrace();
            }
            catch (DialogCanceledException e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    public ScreenShooter(int xMin, int yMin, int xMax, int yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.addMouseListener(this);
        this.frame = new JFrame();
        this.frame.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ScreenShooter.this.cancel();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.frame.setUndecorated(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        this.bounds = new Rectangle[screens.length];
        for (int i = 0; i < this.bounds.length; ++i) {
            this.bounds[i] = screens[i].getDefaultConfiguration().getBounds();
        }
    }

    private void cancel() {
        if (this.isDragging) {
            this.stopDrag();
            this.dragStart = null;
            this.dragEnd = null;
        } else {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    ScreenShooter.this.frame.setVisible(false);
                    ScreenShooter.this.frame.dispose();
                    ScreenShooter.this.setVisible(false);
                    ScreenShooter.this.dispose();
                }
            };
        }
    }

    private Point convertToMagnifier(Point mag, Point p) {
        int tx = (p.x - this.mouse.x) * 5 + this.mouse.x + mag.x + 75 - this.mouse.x;
        int ty = (p.y - this.mouse.y) * 5 + this.mouse.y + mag.y + 75 - this.mouse.y;
        return new Point(tx, ty);
    }

    private BufferedImage cut(int x1, int y1, int x2, int y2) {
        int width = Math.abs(x1 - x2) + 1;
        int height = Math.abs(y1 - y2) + 1;
        int sX = Math.min(x1, x2);
        int sY = Math.min(y1, y2);
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage ret = new BufferedImage(width, height, 1);
        Graphics2D gb = (Graphics2D)ret.getGraphics();
        gb.drawImage(this.image, 0, 0, width, height, sX, sY, sX + width, sY + height, null);
        gb.dispose();
        return ret;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    private void drawBigCross(Graphics2D gb) {
        gb.setStroke(new BasicStroke(1.0f));
        gb.setColor(Color.GRAY);
        Area clip = new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        Area subClip = new Area(new Rectangle2D.Double(this.mouse.x - 15, this.mouse.y - 15, 30.0, 30.0));
        clip.subtract(subClip);
        gb.setClip(clip);
        float[] dash = new float[]{10.0f};
        gb.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, System.currentTimeMillis() / 50L % 20L));
        gb.drawLine(0, this.mouse.y, this.image.getWidth(null), this.mouse.y);
        gb.drawLine(this.mouse.x, 0, this.mouse.x, this.image.getHeight(null));
        gb.setClip(null);
        gb.setColor(Color.BLACK);
        gb.setStroke(new BasicStroke(1.0f));
        gb.drawLine(this.mouse.x, this.mouse.y, this.mouse.x, this.mouse.y);
    }

    private Rectangle getDeviceBounds() {
        for (Rectangle r : this.bounds) {
            if (this.mouse.x < r.x || this.mouse.x > r.x + r.width || this.mouse.y < r.y || this.mouse.y > r.y + r.height) continue;
            return r;
        }
        return null;
    }

    public BufferedImage getFullScreenShot() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics gd = img.getGraphics();
        gd.drawImage(this.image, 0, 0, null);
        gd.dispose();
        return img;
    }

    private Point getMagnifierPosition() {
        int y;
        Rectangle bounds = this.getDeviceBounds();
        if (bounds == null) {
            return null;
        }
        int x = this.mouse.x + 20;
        if (x + 150 > bounds.x + bounds.width) {
            x = this.mouse.x - 150 - 20;
        }
        if ((y = this.mouse.y - 150 - 20) < bounds.y) {
            y = this.mouse.y + 20;
        }
        return new Point(x, y);
    }

    public BufferedImage getScreenshot() throws InterruptedException {
        while (this.screenshot == null && !this.disposed) {
            Thread.sleep(100L);
        }
        return this.screenshot;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            return;
        }
        if (this.isDragging) {
            this.stopDrag();
            this.setVisible(false);
            this.frame.setVisible(false);
            new Thread(){

                @Override
                public void run() {
                    ScreenShooter.this.screenshot = ScreenShooter.this.cut(((ScreenShooter)ScreenShooter.this).dragStart.x, ((ScreenShooter)ScreenShooter.this).dragStart.y, ((ScreenShooter)ScreenShooter.this).dragEnd.x, ((ScreenShooter)ScreenShooter.this).dragEnd.y);
                    ScreenShooter.this.frame.dispose();
                    ScreenShooter.this.dispose();
                }
            }.start();
        } else if (!this.isDragging) {
            this.startDrag();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouse = e.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e != null) {
            this.mouse = e.getPoint();
        } else {
            PointerInfo pi = MouseInfo.getPointerInfo();
            this.mouse = pi.getLocation();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            this.cancel();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
    }

    private void paintMagnifier(Graphics2D gb) {
        Point pos = this.getMagnifierPosition();
        gb.drawImage(this.image, pos.x, pos.y, pos.x + 150, pos.y + 150, this.mouse.x - 15, this.mouse.y - 15, this.mouse.x + 15, this.mouse.y + 15, Color.BLACK, null);
        Composite comp = gb.getComposite();
        gb.setComposite(AlphaComposite.getInstance(3, 0.3f));
        gb.setColor(Color.BLACK);
        gb.setStroke(new BasicStroke(5.0f));
        gb.drawLine(pos.x + 2, pos.y + 75 + 2, pos.x + 150 - 2, pos.y + 75 + 2);
        gb.drawLine(pos.x + 75 + 2, pos.y + 2, pos.x + 75 + 2, pos.y + 75 - 3);
        gb.drawLine(pos.x + 75 + 2, pos.y + 75 + 7, pos.x + 75 + 2, pos.y + 150 - 2);
        gb.setComposite(comp);
        if (this.isDragging) {
            int startX = Math.min(this.dragStart.x, this.mouse.x);
            int startY = Math.min(this.dragStart.y, this.mouse.y);
            int endX = Math.max(this.mouse.x, this.dragStart.x) + 1;
            int endY = Math.max(this.mouse.y, this.dragStart.y) + 1;
            Point start = this.convertToMagnifier(pos, new Point(startX, startY));
            Point end = this.convertToMagnifier(pos, new Point(endX, endY));
            gb.setStroke(new BasicStroke(1.0f));
            gb.setColor(Color.BLUE);
            int x = Math.max(pos.x, start.x);
            int y = Math.max(start.y, pos.y);
            int width = Math.min(75 + (x == pos.x ? 5 : 0), end.x - start.x);
            int height = Math.min(75 + (y == pos.y ? 5 : 0), end.y - start.y);
            gb.drawRect(x, y, width, height);
            comp = gb.getComposite();
            gb.setComposite(AlphaComposite.getInstance(3, 0.1f));
            gb.fillRect(x, y, width, height);
            gb.setComposite(comp);
            gb.setStroke(new BasicStroke(1.0f));
            gb.setColor(Color.WHITE);
            gb.fillRect(pos.x + 1, pos.y + 150 - gb.getFontMetrics().getHeight(), 149, gb.getFontMetrics().getHeight());
            gb.setColor(Color.GRAY);
            gb.drawLine(pos.x, pos.y + 150 - gb.getFontMetrics().getHeight(), pos.x + 150, pos.y + 150 - gb.getFontMetrics().getHeight());
            String dimension = "(px)W:" + (Math.abs(this.mouse.x - this.dragStart.x) + 1) + "; H:" + (Math.abs(this.mouse.y - this.dragStart.y) + 1);
            gb.getFontMetrics().stringWidth(dimension);
        }
        gb.setColor(Color.BLACK);
        gb.setStroke(new BasicStroke(1.0f));
        gb.drawRect(pos.x, pos.y, 150, 150);
    }

    private void setImage(Image complete, Image completeGrayed) {
        this.image = complete;
        this.grayedImage = completeGrayed;
        this.setSize(complete.getWidth(null), complete.getHeight(null));
    }

    public void start() {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                ScreenShooter.this.frame.setLocation(-10000, -10000);
                ScreenShooter.this.frame.setVisible(true);
                ScreenShooter.this.frame.requestFocus();
                ScreenShooter.this.setVisible(true);
                ScreenShooter.this.setLocation(ScreenShooter.this.xMin, ScreenShooter.this.yMin);
                ScreenShooter.this.setAlwaysOnTop(false);
                ScreenShooter.this.requestFocus();
                ScreenShooter.this.requestFocusInWindow();
                ScreenShooter.this.createBufferStrategy(2);
                int[] pixels = new int[256];
                Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
                Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
                ScreenShooter.this.setCursor(transparentCursor);
                ScreenShooter.this.addMouseMotionListener(ScreenShooter.this);
                ScreenShooter.this.mouseMoved(null);
                new Thread("Asynchpainter"){

                    @Override
                    public void run() {
                        long t = System.currentTimeMillis();
                        int frame = 20;
                        ScreenShooter.this.updateGUI(ScreenShooter.this.getBufferStrategy());
                        try {
                            Thread.sleep(Math.max(0L, 20L - System.currentTimeMillis() - t));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        while (!ScreenShooter.this.disposed) {
                            t = System.currentTimeMillis();
                            ScreenShooter.this.updateGUI(ScreenShooter.this.getBufferStrategy());
                            try {
                                long wait = 20L - (System.currentTimeMillis() - t);
                                if (wait <= 0L) continue;
                                Thread.sleep(wait);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }.start();
                return null;
            }
        }.getReturnValue();
    }

    private void startDrag() {
        this.dragStart = this.mouse;
        this.isDragging = true;
        System.out.println("Start Drag " + this.dragStart);
    }

    private void stopDrag() {
        this.isDragging = false;
        this.dragEnd = this.mouse;
        System.out.println("StopDrag ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGUI(BufferStrategy bufferStrategy) {
        Graphics2D gb = null;
        try {
            gb = (Graphics2D)bufferStrategy.getDrawGraphics();
            Point tempDrag = this.dragStart;
            if (this.isDragging && tempDrag != null) {
                int startX = Math.min(tempDrag.x, this.mouse.x);
                int startY = Math.min(tempDrag.y, this.mouse.y);
                gb.drawImage(this.grayedImage, 0, 0, null);
                int endX = Math.max(this.mouse.x, tempDrag.x);
                int endY = Math.max(this.mouse.y, tempDrag.y);
                gb.drawImage(this.image, startX, startY, endX, endY, startX, startY, endX, endY, null);
                gb.setColor(Color.GRAY);
                this.drawBigCross(gb);
                gb.setColor(Color.BLACK);
                gb.setStroke(new BasicStroke(1.0f));
                gb.drawRect(startX, startY, endX - startX, endY - startY);
                gb.setStroke(new BasicStroke(1.0f));
            } else {
                gb.drawImage(this.image, 0, 0, null);
                this.drawBigCross(gb);
            }
            this.paintMagnifier(gb);
            String str = this.mouse.y + " px";
            Rectangle db = this.getDeviceBounds();
            int width = gb.getFontMetrics().stringWidth(str) + 10;
            int height = gb.getFontMetrics().getHeight() + 5;
            gb.setStroke(new BasicStroke(1.0f));
            gb.setColor(Color.white);
            int y = this.mouse.y - height / 2;
            if (y < db.y) {
                y = db.y;
            }
            if (y + height + 5 > db.height + db.y) {
                y = db.height + db.y - height - 5;
            }
            gb.fillRect(db.x + db.width - width - 10, y, width, height);
            gb.setColor(Color.GRAY);
            gb.drawRect(db.x + db.width - width - 10, y, width, height);
            gb.drawString(str, db.x + db.width - width - 5, y + height - 5);
            str = this.mouse.x + " px";
            width = gb.getFontMetrics().stringWidth(str) + 10;
            height = gb.getFontMetrics().getHeight() + 5;
            gb.setStroke(new BasicStroke(1.0f));
            gb.setColor(Color.white);
            int x = this.mouse.x - width / 2;
            if (x < db.x + 5) {
                x = db.x + 5;
            }
            if (x + width + 5 > db.x + db.width) {
                x = db.x + db.width - width - 5;
            }
            if (db.y + db.height - height - 5 - y <= height) {
                gb.fillRect(x, db.y + (CrossSystem.isMac() ? 27 : 5), width, height);
                gb.setColor(Color.GRAY);
                gb.drawRect(x, CrossSystem.isMac() ? 27 : 5, width, height);
                gb.drawString(str, x + 5, CrossSystem.isMac() ? 22 + height : height);
            } else {
                gb.fillRect(x, db.y + db.height - height - 5, width, height);
                gb.setColor(Color.GRAY);
                gb.drawRect(x, db.y + db.height - height - 5, width, height);
                gb.drawString(str, x + 5, db.y + db.height - 10);
            }
            try {
                bufferStrategy.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                gb.dispose();
            }
            catch (Throwable throwable) {}
        }
    }
}

