/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.scheduler;

import java.lang.reflect.Modifier;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class DelayedRunnable
implements Runnable {
    private final ScheduledExecutorService service;
    private final long delayInMS;
    private final AtomicLong lastRunRequest = new AtomicLong(0L);
    private final AtomicLong firstRunRequest = new AtomicLong(0L);
    private final AtomicBoolean delayerSet = new AtomicBoolean(false);
    private final long maxInMS;
    private final AtomicBoolean delayerEnabled = new AtomicBoolean(true);

    public static String getCaller() {
        Throwable stackTrace = new Throwable();
        try {
            for (StackTraceElement element : stackTrace.getStackTrace()) {
                String currentClassName = element.getClassName();
                Class<?> currentClass = Class.forName(currentClassName, true, Thread.currentThread().getContextClassLoader());
                if (Modifier.isAbstract(currentClass.getModifiers()) || Modifier.isInterface(currentClass.getModifiers())) continue;
                return currentClassName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ScheduledExecutorService getNewScheduledExecutorService() {
        final String caller = DelayedRunnable.getCaller();
        ScheduledThreadPoolExecutor ret = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                if (caller != null) {
                    thread.setName("Scheduler:" + caller);
                }
                thread.setDaemon(true);
                return thread;
            }
        });
        ret.setMaximumPoolSize(1);
        ret.setKeepAliveTime(10000L, TimeUnit.MILLISECONDS);
        ret.allowCoreThreadTimeOut(true);
        return ret;
    }

    public DelayedRunnable(long minDelayInMS) {
        this(DelayedRunnable.getNewScheduledExecutorService(), minDelayInMS);
    }

    public DelayedRunnable(long minDelayInMS, long maxDelayInMS) {
        this(DelayedRunnable.getNewScheduledExecutorService(), minDelayInMS, maxDelayInMS);
    }

    public DelayedRunnable(ScheduledExecutorService service, long delayInMS) {
        this(service, delayInMS, -1L);
    }

    public DelayedRunnable(ScheduledExecutorService service, long minDelayInMS, long maxDelayInMS) {
        this.service = service;
        this.delayInMS = minDelayInMS;
        this.maxInMS = maxDelayInMS;
        if (this.delayInMS <= 0L) {
            throw new IllegalArgumentException("minDelay must be >0");
        }
        if (this.maxInMS == 0L) {
            throw new IllegalArgumentException("maxDelay must be !=0");
        }
    }

    public ScheduledExecutorService getService() {
        return this.service;
    }

    public abstract void delayedrun();

    public String getID() {
        return null;
    }

    public boolean isDelayerActive() {
        return this.delayerSet.get();
    }

    public boolean isDelayerEnabled() {
        return this.delayerEnabled.get();
    }

    public void resetAndStart() {
        this.run();
    }

    public long getMinimumDelay() {
        return this.delayInMS;
    }

    public long getMaximumDelay() {
        return this.maxInMS;
    }

    public long getEstimatedNextRun() {
        long firstRunRequest = this.firstRunRequest.get();
        if (firstRunRequest > 0L) {
            long lastRunRequest = this.lastRunRequest.get();
            long currentTime = System.currentTimeMillis();
            return Math.max(0L, this.delayInMS - (currentTime - lastRunRequest));
        }
        return -1L;
    }

    @Override
    public void run() {
        if (!this.isDelayerEnabled()) {
            try {
                this.delayedrun();
            }
            catch (Throwable e) {
                this.onUncaughtException(e);
            }
            return;
        }
        this.lastRunRequest.set(System.currentTimeMillis());
        if (this.delayerSet.getAndSet(true)) {
            return;
        }
        this.firstRunRequest.compareAndSet(0L, System.currentTimeMillis());
        this.service.schedule(new Runnable(){

            private void delayAgain(long currentTime, Long nextDelay, long minDif, long thisRequestRun) {
                if (!DelayedRunnable.this.delayerSet.get()) {
                    return;
                }
                if (nextDelay == null) {
                    nextDelay = Math.max(0L, DelayedRunnable.this.delayInMS - minDif);
                }
                if (nextDelay < 10L) {
                    this.runNow(currentTime, thisRequestRun, minDif);
                    return;
                }
                DelayedRunnable.this.service.schedule(this, (long)nextDelay, TimeUnit.MILLISECONDS);
            }

            @Override
            public void run() {
                if (!DelayedRunnable.this.delayerSet.get()) {
                    return;
                }
                long thisRunRequest = DelayedRunnable.this.lastRunRequest.get();
                long currentTime = System.currentTimeMillis();
                long minDif = currentTime - thisRunRequest;
                if (minDif >= DelayedRunnable.this.delayInMS) {
                    this.runNow(currentTime, thisRunRequest, minDif);
                    return;
                }
                long firstRunRequest = DelayedRunnable.this.firstRunRequest.get();
                Long nextDelay = null;
                if (DelayedRunnable.this.maxInMS > 0L) {
                    long maxDif = currentTime - firstRunRequest;
                    if (maxDif >= DelayedRunnable.this.maxInMS) {
                        this.runNow(currentTime, thisRunRequest, minDif);
                        return;
                    }
                    long delay = DelayedRunnable.this.maxInMS - maxDif;
                    nextDelay = Math.min(delay, DelayedRunnable.this.delayInMS);
                }
                this.delayAgain(currentTime, nextDelay, minDif, thisRunRequest);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void runNow(long currentTime, long thisRunRequest, long minDif) {
                try {
                    DelayedRunnable.this.delayedrun();
                }
                catch (Throwable e) {
                    DelayedRunnable.this.onUncaughtException(e);
                }
                finally {
                    if (thisRunRequest != DelayedRunnable.this.lastRunRequest.get()) {
                        DelayedRunnable.this.firstRunRequest.set(currentTime);
                        this.delayAgain(currentTime, DelayedRunnable.this.delayInMS, minDif, thisRunRequest);
                    } else {
                        this.stop();
                    }
                }
            }

            private void stop() {
                DelayedRunnable.this.firstRunRequest.set(0L);
                DelayedRunnable.this.delayerSet.set(false);
            }
        }, this.delayInMS, TimeUnit.MILLISECONDS);
    }

    protected void onUncaughtException(Throwable e) {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (handler != null) {
            handler.uncaughtException(Thread.currentThread(), e);
        } else {
            e.printStackTrace();
        }
    }

    public void setDelayerEnabled(boolean b) {
        if (this.delayerEnabled.getAndSet(b) == b) {
            return;
        }
        if (!b) {
            this.stop();
        }
    }

    public boolean stop() {
        return this.delayerSet.compareAndSet(true, false);
    }
}

