/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources;

import java.net.URL;
import java.util.HashMap;

public class ThemeContext {
    private boolean usecache = true;
    private boolean createMultiResolutionImages = true;
    private boolean doNotUpscaleButThrowException = false;
    private HashMap<String, URL> urls = new HashMap();
    private Target target = null;
    private boolean debugDrawEnabled = false;

    public boolean isDebugDrawEnabled() {
        return this.debugDrawEnabled;
    }

    public ThemeContext setDebugDrawEnabled(boolean debugDrawEnabled) {
        this.debugDrawEnabled = debugDrawEnabled;
        return this;
    }

    public ThemeContext withDebugDrawEnabled() {
        return this.setDebugDrawEnabled(true);
    }

    public boolean isUsecache() {
        return this.usecache;
    }

    public ThemeContext setUsecache(boolean usecache) {
        this.usecache = usecache;
        return this;
    }

    public ThemeContext withoutCache() {
        return this.setUsecache(false);
    }

    public boolean isCreateMultiResolutionImages() {
        return this.createMultiResolutionImages;
    }

    public ThemeContext setCreateMultiResolutionImages(boolean createMultiResolutionImages) {
        this.createMultiResolutionImages = createMultiResolutionImages;
        return this;
    }

    public ThemeContext withoutMultiResolutionImages() {
        return this.setCreateMultiResolutionImages(false);
    }

    public boolean isDoNotUpscaleButThrowException() {
        return this.doNotUpscaleButThrowException;
    }

    public ThemeContext setDoNotUpscaleButThrowException(boolean doNotUpscaleButThrowException) {
        this.doNotUpscaleButThrowException = doNotUpscaleButThrowException;
        return this;
    }

    public ThemeContext withExceptionOnUpscale() {
        return this.setDoNotUpscaleButThrowException(true);
    }

    public String toKeyID() {
        StringBuilder key = null;
        if (this.isCreateMultiResolutionImages()) {
            key = key == null ? new StringBuilder() : key;
            key.append(".MULTIRES");
        }
        if (this.isDoNotUpscaleButThrowException()) {
            key = key == null ? new StringBuilder() : key;
            key.append(".NO_UPSCALE");
        }
        if (this.isDebugDrawEnabled()) {
            key = key == null ? new StringBuilder() : key;
            key.append(".DEBUG");
        }
        return key == null ? "" : key.toString();
    }

    public ThemeContext putURL(String relPath, URL url) {
        this.urls.put(relPath, url);
        return this;
    }

    public URL getURL(String relativePath) {
        return this.urls.get(relativePath);
    }

    protected void ensureTarget(Target newTarget) {
        if (this.target == null) {
            this.target = newTarget;
        }
    }

    protected Target getTarget() {
        return this.target;
    }

    public static enum Target {
        IMAGE,
        ICON;

    }
}

