/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.images.IconPipe;
import org.appwork.utils.reflection.Clazz;

public class MultiResolutionImageHelper {
    private static final Constructor<?> CONSTRUCTOR;
    private static final Class<?> CLS;
    private static final Class<?> INTFS;
    private static final Method METHOD_GETRESOLUTION_VARIANTS;
    private static final Method METHOD_GETRESOLUTION_VARIANT;
    private static final boolean SUPPORTED;

    public static void sortImagesBySize(List<Image> variants) {
        Collections.sort(variants, new Comparator<Image>(){

            @Override
            public int compare(Image o1, Image o2) {
                return CompareUtils.compareLong((long)o1.getWidth(null) * (long)o1.getHeight(null), (long)o2.getWidth(null) * (long)o2.getHeight(null));
            }
        });
    }

    private static void checkSupported() throws UnsupportedOperationException {
        if (!SUPPORTED) {
            throw new UnsupportedOperationException();
        }
    }

    public static Image create(int i, Image ... images) {
        MultiResolutionImageHelper.checkSupported();
        try {
            Image base = images[i];
            List<Image> list = Arrays.asList(images);
            MultiResolutionImageHelper.sortImagesBySize(list);
            return (Image)CONSTRUCTOR.newInstance(list.indexOf(base), list.toArray(new Image[0]));
        }
        catch (SecurityException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (InstantiationException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (IllegalAccessException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (IllegalArgumentException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (InvocationTargetException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
    }

    public static boolean isInstanceOf(Image img) {
        return img != null && INTFS != null && Clazz.isInstanceof(img.getClass(), INTFS);
    }

    public static List<Image> getResolutionVariants(Image input) {
        MultiResolutionImageHelper.checkSupported();
        try {
            return (List)METHOD_GETRESOLUTION_VARIANTS.invoke((Object)input, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LogV3.log(e);
            throw new WTFException();
        }
        catch (IllegalArgumentException e) {
            LogV3.log(e);
            throw new WTFException();
        }
        catch (InvocationTargetException e) {
            LogV3.log(e);
            throw new WTFException();
        }
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static Image create(List<Image> images) {
        MultiResolutionImageHelper.checkSupported();
        MultiResolutionImageHelper.sortImagesBySize(images);
        return MultiResolutionImageHelper.create(0, images.toArray(new Image[0]));
    }

    public static Image create(Image base, List<Image> images) {
        MultiResolutionImageHelper.checkSupported();
        try {
            ArrayList<Image> list = new ArrayList<Image>(images);
            if (!list.contains(base)) {
                list.add(base);
            }
            MultiResolutionImageHelper.sortImagesBySize(list);
            return (Image)CONSTRUCTOR.newInstance(list.indexOf(base), list.toArray(new Image[0]));
        }
        catch (SecurityException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (InstantiationException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (IllegalAccessException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (IllegalArgumentException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
        catch (InvocationTargetException e) {
            LogV3.log(e);
            throw new WTFException(e);
        }
    }

    public static Image getResolutionVariant(Image input, double width, double height) {
        MultiResolutionImageHelper.checkSupported();
        try {
            return (Image)METHOD_GETRESOLUTION_VARIANT.invoke((Object)input, width, height);
        }
        catch (IllegalAccessException e) {
            LogV3.log(e);
            throw new WTFException();
        }
        catch (IllegalArgumentException e) {
            LogV3.log(e);
            throw new WTFException();
        }
        catch (InvocationTargetException e) {
            LogV3.log(e);
            throw new WTFException();
        }
    }

    public static List<Image> getResolutionVariants(Icon icon) {
        while (icon != null) {
            if (icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                if (MultiResolutionImageHelper.isInstanceOf(image)) {
                    return MultiResolutionImageHelper.getResolutionVariants(image);
                }
                return Arrays.asList(image);
            }
            if (!(icon instanceof IconPipe)) continue;
            icon = ((IconPipe)((Object)icon)).getDelegate();
        }
        return null;
    }

    public static double getHighestMonitorScaling() {
        if (Application.isHeadless()) {
            return 1.0;
        }
        double highestRequiredScale = 1.0;
        for (GraphicsDevice sd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            AffineTransform tx = sd.getDefaultConfiguration().getDefaultTransform();
            highestRequiredScale = Math.max(highestRequiredScale, tx.getScaleX());
            highestRequiredScale = Math.max(highestRequiredScale, tx.getScaleY());
        }
        return highestRequiredScale;
    }

    static {
        boolean isSupported = false;
        Class<?> cls = null;
        Class<?> intfs = null;
        Constructor<?> cons = null;
        Method variants = null;
        Method variant = null;
        if (JavaVersion.getVersion().isMinimum(JavaVersion.JVM_9_0)) {
            try {
                cls = Class.forName("java.awt.image.BaseMultiResolutionImage");
                intfs = Class.forName("java.awt.image.MultiResolutionImage");
                cons = cls.getConstructor(Integer.TYPE, Image[].class);
                variants = intfs.getMethod("getResolutionVariants", new Class[0]);
                variant = intfs.getMethod("getResolutionVariant", Double.TYPE, Double.TYPE);
                isSupported = true;
            }
            catch (NoSuchMethodException e) {
                LogV3.log(e);
            }
            catch (SecurityException e) {
                LogV3.log(e);
            }
            catch (IllegalArgumentException e) {
                LogV3.log(e);
            }
            catch (ClassNotFoundException e) {
                LogV3.log(e);
            }
        }
        SUPPORTED = isSupported;
        CLS = cls;
        INTFS = intfs;
        CONSTRUCTOR = cons;
        METHOD_GETRESOLUTION_VARIANTS = variants;
        METHOD_GETRESOLUTION_VARIANT = variant;
    }
}

