/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.remoteapi.exceptions.DeviceErrorResponse;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.Exceptions;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.HttpConnectionExceptionHandler;
import org.appwork.utils.net.httpserver.requests.HttpRequestInterface;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.responses.HttpResponseInterface;

public class BasicRemoteAPIException
extends Exception
implements HttpConnectionExceptionHandler {
    private static final long serialVersionUID = 1L;
    private HttpRequestInterface request;
    private HttpResponseInterface response;
    private final String type;
    private final HTTPConstants.ResponseCode code;
    private final Object data;

    public BasicRemoteAPIException(IOException e) {
        this(e, "UNKNOWN", HTTPConstants.ResponseCode.SERVERERROR_INTERNAL, null);
    }

    public BasicRemoteAPIException(HTTPConstants.ResponseCode code2) {
        this(null, code2.name(), code2, null);
    }

    public BasicRemoteAPIException(String name, HTTPConstants.ResponseCode code2) {
        this(null, name, code2, null);
    }

    public BasicRemoteAPIException(Throwable cause, String name, HTTPConstants.ResponseCode code, Object data) {
        super(name + "(" + code + ")", cause);
        this.data = data;
        this.type = name;
        this.code = code;
    }

    public HTTPConstants.ResponseCode getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public HttpRequestInterface getRequest() {
        return this.request;
    }

    public HttpResponseInterface getResponse() {
        return this.response;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean handle(HttpResponse response) throws IOException {
        return this.handle(response, false);
    }

    protected Object getErrorObject() {
        return new DeviceErrorResponse(this.getType(), this.getData());
    }

    public boolean handle(HttpResponse response, boolean gzip) throws IOException {
        String str = JSonStorage.serializeToJson(this.getErrorObject());
        byte[] bytes = str.getBytes("UTF-8");
        if (gzip) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipout = new GZIPOutputStream(baos);
            gzipout.write(bytes);
            gzipout.close();
            bytes = baos.toByteArray();
        }
        response.setResponseCode(this.getCode());
        response.getResponseHeaders().add(new HTTPHeader("Access-Control-Allow-Origin", "*"));
        response.getResponseHeaders().add(new HTTPHeader("Content-Type", "application/json; charset=UTF-8"));
        response.getResponseHeaders().add(new HTTPHeader("Content-Length", bytes.length + ""));
        response.getOutputStream(true).write(bytes);
        response.getOutputStream(true).flush();
        return true;
    }

    public void setRequest(HttpRequestInterface request) {
        this.request = request;
    }

    public void setResponse(HttpResponseInterface response) {
        this.response = response;
    }

    public static BasicRemoteAPIException wrap(Throwable e) {
        if (e instanceof BasicRemoteAPIException) {
            return (BasicRemoteAPIException)e;
        }
        return new BasicRemoteAPIException(e, e.getClass().getSimpleName(), HTTPConstants.ResponseCode.SERVERERROR_INTERNAL, null);
    }

    public void writeToLogger(LogInterface logger) {
        if (this.request == null) {
            logger.info("Exception in Request **\r\n" + Exceptions.getStackTrace(this) + "\r\ndata:" + this.data);
        } else {
            logger.info("Exception in Request " + this.request.getId() + "/" + this.request.getRequestedURL() + "\r\n" + Exceptions.getStackTrace(this) + "\r\ndata:" + this.data);
        }
    }
}

