/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.events.json;

import java.util.regex.Pattern;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.storage.Storable;

public class SubscriptionResponse
implements Storable {
    protected long subscriptionid = -1L;
    protected boolean subscribed = false;
    protected String[] subscriptions = null;
    protected String[] exclusions = null;
    protected long maxPolltimeout = -1L;
    protected long maxKeepalive = -1L;

    public SubscriptionResponse() {
    }

    private final String[] convert(Pattern[] pattern) {
        if (pattern == null || pattern.length == 0) {
            return null;
        }
        String[] ret = new String[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            ret[i] = pattern[i].pattern();
        }
        return ret;
    }

    public SubscriptionResponse(Subscriber subscriber) {
        if (subscriber != null) {
            this.subscriptionid = subscriber.getSubscriptionID();
            this.subscriptions = this.convert(subscriber.getSubscriptions());
            this.exclusions = this.convert(subscriber.getExclusions());
            this.maxKeepalive = subscriber.getMaxKeepalive();
            this.setMaxPolltimeout(subscriber.getPollTimeout());
            this.setSubscribed(subscriber.isAlive() && !subscriber.isExpired());
        }
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public long getMaxKeepalive() {
        return this.maxKeepalive;
    }

    public long getMaxPolltimeout() {
        return this.maxPolltimeout;
    }

    public long getSubscriptionid() {
        return this.subscriptionid;
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setExclusions(String[] exclusions) {
        this.exclusions = exclusions;
    }

    public void setMaxKeepalive(long maxKeepalive) {
        this.maxKeepalive = maxKeepalive;
    }

    public void setMaxPolltimeout(long maxPolltimeout) {
        this.maxPolltimeout = maxPolltimeout;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public void setSubscriptionid(long subscriptionid) {
        this.subscriptionid = subscriptionid;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }
}

