/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.events;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.appwork.remoteapi.events.EventObject;

public class Subscriber {
    protected static final AtomicLong ID = new AtomicLong(System.currentTimeMillis());
    protected volatile Pattern[] subscriptions;
    protected volatile Pattern[] exclusions;
    protected final ArrayDeque<EventObject> events = new ArrayDeque();
    protected final long subscriptionID;
    protected long lastPolledTimestamp = System.currentTimeMillis();
    protected long pollTimeout = 25000L;
    protected long maxKeepalive = 120000L;
    protected final AtomicBoolean alive = new AtomicBoolean(true);

    private static long createUniqueAlltimeID() {
        long lastID;
        long id = -1L;
        do {
            lastID = ID.get();
            id = System.currentTimeMillis();
            if (id < lastID) {
                id = lastID + 1L;
                continue;
            }
            if (id != lastID) continue;
            ++id;
        } while (!ID.compareAndSet(lastID, id));
        return id;
    }

    public boolean isAlive() {
        return this.alive.get();
    }

    public void kill() {
        this.alive.set(false);
    }

    protected Subscriber(Pattern[] subscriptions, Pattern[] exclusions) {
        this.setSubscriptions(subscriptions);
        this.setExclusions(exclusions);
        this.subscriptionID = Subscriber.createUniqueAlltimeID();
    }

    protected Subscriber(long subscriptionID, Pattern[] subscriptions, Pattern[] exclusions) {
        this.setSubscriptions(subscriptions);
        this.setExclusions(exclusions);
        this.subscriptionID = subscriptionID;
    }

    public Pattern[] getExclusions() {
        return (Pattern[])this.exclusions.clone();
    }

    public long getLastPolledTimestamp() {
        return this.lastPolledTimestamp;
    }

    public long getMaxKeepalive() {
        return this.maxKeepalive;
    }

    protected Object getModifyLock() {
        return this;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public long getSubscriptionID() {
        return this.subscriptionID;
    }

    public Pattern[] getSubscriptions() {
        return (Pattern[])this.subscriptions.clone();
    }

    protected boolean isSubscribed(EventObject event) {
        if (this.subscriptions.length == 0 || !this.isAlive() || this.isExpired()) {
            return false;
        }
        String eventID = event.getPublisher().getPublisherName().concat(".").concat(event.getEventid());
        return this.isSubscribed(eventID);
    }

    public boolean isSubscribed(String eventID) {
        if (this.isAlive() && !this.isExpired() && this.subscriptions.length > 0) {
            for (Pattern subscription : this.subscriptions) {
                try {
                    if (!subscription.matcher(eventID).find()) continue;
                    for (Pattern exclusion : this.exclusions) {
                        try {
                            if (!exclusion.matcher(eventID).find()) continue;
                            return false;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    protected void keepAlive() {
        this.lastPolledTimestamp = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return this.lastPolledTimestamp + this.maxKeepalive < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener() {
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventObject poll(long waitfor) throws InterruptedException {
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            this.keepAlive();
            EventObject ret = this.events.poll();
            if (ret == null && waitfor > 0L) {
                this.events.wait(waitfor);
                ret = this.events.poll();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(List<EventObject> filtered) {
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            for (EventObject event : filtered) {
                this.push(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(EventObject event) {
        if (event == null) {
            return;
        }
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            if (event.getCollapseKey() != null) {
                Iterator<EventObject> it = this.events.descendingIterator();
                while (it.hasNext()) {
                    EventObject next = it.next();
                    if (next.getCollapseKey() == null || !next.getCollapseKey().equals(event.getCollapseKey())) continue;
                    it.remove();
                    break;
                }
            }
            this.events.offerLast(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushBack(List<EventObject> pushBackEvents) {
        if (pushBackEvents.size() == 0) {
            return;
        }
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            if (this.events.size() == 0) {
                this.events.addAll(pushBackEvents);
                return;
            }
            ArrayList<EventObject> addFirst = new ArrayList<EventObject>(pushBackEvents.size());
            block3: for (EventObject pushBackEvent : pushBackEvents) {
                if (pushBackEvent.getCollapseKey() != null) {
                    for (EventObject currentEvent : this.events) {
                        if (currentEvent.getCollapseKey() == null || !currentEvent.getCollapseKey().equals(pushBackEvent.getCollapseKey())) continue;
                        continue block3;
                    }
                }
                addFirst.add(pushBackEvent);
            }
            if (addFirst.size() == 0) {
                return;
            }
            ArrayList<EventObject> backup = new ArrayList<EventObject>(this.events);
            this.events.clear();
            this.events.addAll(addFirst);
            this.events.addAll(backup);
        }
    }

    protected void setExclusions(Pattern[] exclusions) {
        this.exclusions = exclusions == null ? new Pattern[0] : this.uniquify(exclusions);
    }

    protected void setMaxKeepalive(long maxKeepalive) {
        maxKeepalive = Math.min(maxKeepalive, 3600000L);
        this.maxKeepalive = maxKeepalive = Math.max(maxKeepalive, 30000L);
    }

    protected void setPollTimeout(long pollTimeout) {
        pollTimeout = Math.min(pollTimeout, 360000L);
        this.pollTimeout = pollTimeout = Math.max(pollTimeout, 1000L);
    }

    protected void setSubscriptions(Pattern[] subscriptions) {
        this.subscriptions = subscriptions == null ? new Pattern[0] : this.uniquify(subscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayDeque<EventObject> arrayDeque = this.events;
        synchronized (arrayDeque) {
            return this.events.size();
        }
    }

    private Pattern[] uniquify(Pattern[] input) {
        if (input == null || input.length == 0) {
            return new Pattern[0];
        }
        return new HashSet<Pattern>(Arrays.asList(input)).toArray(new Pattern[0]);
    }
}

