/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.EventsAPIInterface;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.remoteapi.events.json.EventObjectStorable;
import org.appwork.remoteapi.events.json.PublisherResponse;
import org.appwork.remoteapi.events.json.SubscriptionResponse;
import org.appwork.remoteapi.events.json.SubscriptionStatusResponse;
import org.appwork.remoteapi.events.local.LocalEventsAPIEvent;
import org.appwork.remoteapi.events.local.LocalEventsAPIEventSender;
import org.appwork.remoteapi.exceptions.APIFileNotFoundException;
import org.appwork.remoteapi.exceptions.InternalApiException;

public class EventsAPI
implements EventsAPIInterface,
RemoteAPIEventsSender {
    private final LocalEventsAPIEventSender localEventSender;
    protected final CopyOnWriteArrayList<Subscriber> subscribers = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<EventPublisher> publishers = new CopyOnWriteArrayList();
    protected final Object subscribersCleanupLock = new Object();
    protected Thread cleanupThread = null;

    public EventsAPI() {
        this.localEventSender = new LocalEventsAPIEventSender();
    }

    public LocalEventsAPIEventSender getLocalEventSender() {
        return this.localEventSender;
    }

    public List<Subscriber> getSubscribers() {
        return Collections.unmodifiableList(this.subscribers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionResponse addsubscription(long subscriptionid, String[] subscriptions, String[] exclusions) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            return new SubscriptionResponse();
        }
        Object object = subscriber.getModifyLock();
        synchronized (object) {
            if (exclusions != null) {
                ArrayList<Pattern> newExclusions = new ArrayList<Pattern>(Arrays.asList(subscriber.getExclusions()));
                newExclusions.addAll(this.convertToPatternList(exclusions));
                subscriber.setExclusions(newExclusions.toArray(new Pattern[0]));
            }
            if (subscriptions != null) {
                ArrayList<Pattern> newSubscriptions = new ArrayList<Pattern>(Arrays.asList(subscriber.getSubscriptions()));
                newSubscriptions.addAll(this.convertToPatternList(subscriptions));
                subscriber.setSubscriptions(newSubscriptions.toArray(new Pattern[0]));
            }
        }
        SubscriptionResponse ret = new SubscriptionResponse(subscriber);
        try {
            this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_UPDATE, subscriber));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    private List<Pattern> convertToPatternList(String[] pattern) {
        ArrayList<Pattern> ret = new ArrayList<Pattern>();
        if (pattern != null) {
            for (String pat : pattern) {
                try {
                    ret.add(Pattern.compile(pat));
                }
                catch (Throwable e) {
                    LogV3.log(e);
                }
            }
        }
        return ret;
    }

    private Pattern[] convertToPatternArray(String[] pattern) {
        return this.convertToPatternList(pattern).toArray(new Pattern[0]);
    }

    protected Subscriber getSubscriber(long subscriptionid) {
        for (Subscriber subscriber : this.subscribers) {
            if (subscriptionid != subscriber.getSubscriptionID()) continue;
            return subscriber;
        }
        return null;
    }

    protected EventObject pollEvent(Subscriber subscriber, long waitfor) throws InterruptedException {
        return subscriber.poll(waitfor);
    }

    protected void pushBackEvent(Subscriber subscriber, List<EventObject> events) {
        subscriber.pushBack(events);
    }

    @Override
    public SubscriptionResponse changesubscriptiontimeouts(long subscriptionid, long polltimeout, long maxkeepalive) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            return new SubscriptionResponse();
        }
        subscriber.setMaxKeepalive(maxkeepalive);
        subscriber.setPollTimeout(polltimeout);
        subscriber.notifyListener();
        SubscriptionResponse ret = new SubscriptionResponse(subscriber);
        try {
            this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_UPDATE, subscriber));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public SubscriptionResponse getsubscription(long subscriptionid) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber != null) {
            SubscriptionResponse ret = new SubscriptionResponse(subscriber);
            return ret;
        }
        return new SubscriptionResponse();
    }

    @Override
    public SubscriptionStatusResponse getsubscriptionstatus(long subscriptionid) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            return new SubscriptionStatusResponse();
        }
        subscriber.keepAlive();
        SubscriptionStatusResponse ret = new SubscriptionStatusResponse(subscriber);
        return ret;
    }

    public List<EventPublisher> list() {
        return Collections.unmodifiableList(this.publishers);
    }

    @Override
    public void listen(RemoteAPIRequest request, RemoteAPIResponse response, long subscriptionid) throws APIFileNotFoundException, InternalApiException {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            throw new APIFileNotFoundException();
        }
        ArrayList<EventObject> events = new ArrayList<EventObject>();
        ArrayList<EventObjectStorable> eventStorables = new ArrayList<EventObjectStorable>();
        try {
            EventObject event;
            while (this.getSubscriber(subscriptionid) == subscriber && (event = this.pollEvent(subscriber, events.size() == 0 ? subscriber.getPollTimeout() : 0L)) != null) {
                events.add(event);
                eventStorables.add(new EventObjectStorable(event));
            }
        }
        catch (InterruptedException event) {
            // empty catch block
        }
        try {
            response.getRemoteAPI().writeStringResponse(eventStorables, null, request, response);
        }
        catch (Throwable e) {
            subscriber.pushBack(events);
            throw new InternalApiException(e);
        }
    }

    @Override
    public List<PublisherResponse> listpublisher() {
        ArrayList<PublisherResponse> ret = new ArrayList<PublisherResponse>();
        for (EventPublisher publisher : this.publishers) {
            ret.add(new PublisherResponse(publisher));
        }
        return ret;
    }

    @Override
    public boolean hasSubscriptionFor(EventPublisher publisher, String eventID) {
        if (eventID != null && this.subscribers.size() > 0) {
            String event = publisher.getPublisherName().concat(".").concat(eventID);
            for (Subscriber subscriber : this.subscribers) {
                if (!subscriber.isAlive() || !subscriber.isSubscribed(event)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Long> publishEvent(EventObject event, List<Long> subscriptionids) {
        ArrayList<Long> ret = new ArrayList<Long>();
        String eventID = EventsAPI.getEventID(event);
        if (subscriptionids != null && subscriptionids.size() > 0) {
            for (long subscriptionid : subscriptionids) {
                Subscriber subscriber = this.getSubscriber(subscriptionid);
                if (subscriber == null || !this.push(subscriber, eventID, event)) continue;
                ret.add(subscriber.getSubscriptionID());
            }
        } else {
            for (Subscriber subscriber : this.subscribers) {
                if (!this.push(subscriber, eventID, event)) continue;
                ret.add(subscriber.getSubscriptionID());
            }
        }
        return ret;
    }

    public synchronized boolean register(EventPublisher publisher) {
        if (publisher == null) {
            throw new NullPointerException();
        }
        if (publisher.getPublisherName() == null) {
            throw new IllegalArgumentException("no Publishername given");
        }
        for (EventPublisher existingPublisher : this.publishers) {
            if (existingPublisher == publisher) {
                return false;
            }
            if (!publisher.getPublisherName().equalsIgnoreCase(existingPublisher.getPublisherName())) continue;
            throw new IllegalArgumentException("publisher with same name already registered");
        }
        this.publishers.add(publisher);
        publisher.register(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionResponse removesubscription(long subscriptionid, String[] subscriptions, String[] exclusions) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            return new SubscriptionResponse();
        }
        Object object = subscriber.getModifyLock();
        synchronized (object) {
            if (exclusions != null) {
                ArrayList<Pattern> newExclusions = new ArrayList<Pattern>(Arrays.asList(subscriber.getExclusions()));
                newExclusions.removeAll(this.convertToPatternList(exclusions));
                subscriber.setExclusions(newExclusions.toArray(new Pattern[0]));
            }
            if (subscriptions != null) {
                ArrayList<Pattern> newSubscriptions = new ArrayList<Pattern>(Arrays.asList(subscriber.getSubscriptions()));
                newSubscriptions.removeAll(this.convertToPatternList(subscriptions));
                subscriber.setSubscriptions(newSubscriptions.toArray(new Pattern[0]));
            }
        }
        SubscriptionResponse ret = new SubscriptionResponse(subscriber);
        try {
            this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_UPDATE, subscriber));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionResponse setsubscription(long subscriptionid, String[] subscriptions, String[] exclusions) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber == null) {
            subscriber = new Subscriber(subscriptionid, this.convertToPatternArray(subscriptions), this.convertToPatternArray(exclusions));
            if (this.addSubscriber(subscriber)) {
                return new SubscriptionResponse(subscriber);
            }
            return new SubscriptionResponse();
        }
        Object object = subscriber.getModifyLock();
        synchronized (object) {
            ArrayList<Pattern> newExclusions = new ArrayList<Pattern>();
            if (exclusions != null) {
                newExclusions.addAll(this.convertToPatternList(exclusions));
            }
            subscriber.setExclusions(newExclusions.toArray(new Pattern[0]));
            ArrayList<Pattern> newSubscriptions = new ArrayList<Pattern>();
            if (subscriptions != null) {
                newSubscriptions.addAll(this.convertToPatternList(subscriptions));
            }
            subscriber.setSubscriptions(newSubscriptions.toArray(new Pattern[0]));
        }
        SubscriptionResponse ret = new SubscriptionResponse(subscriber);
        try {
            this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_UPDATE, subscriber));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public boolean addSubscriber(Subscriber subscriber) {
        Subscriber existing;
        if (subscriber != null && subscriber.isAlive() && (existing = this.getSubscriber(subscriber.getSubscriptionID())) == null && this.subscribers.addIfAbsent(subscriber)) {
            this.subscribersCleanupThread();
            try {
                this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_OPENED, subscriber));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean removeSubscriber(Subscriber subscriber) {
        if (subscriber != null && this.subscribers.remove(subscriber)) {
            subscriber.kill();
            subscriber.notifyListener();
            try {
                this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_CLOSED, subscriber));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public SubscriptionResponse subscribe(String[] subscriptions, String[] exclusions) {
        Subscriber subscriber = new Subscriber(this.convertToPatternArray(subscriptions), this.convertToPatternArray(exclusions));
        this.subscribers.add(subscriber);
        this.subscribersCleanupThread();
        SubscriptionResponse ret = new SubscriptionResponse(subscriber);
        try {
            this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_OPENED, subscriber));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribersCleanupThread() {
        Object object = this.subscribersCleanupLock;
        synchronized (object) {
            if (this.cleanupThread != null && this.cleanupThread.isAlive()) {
                return;
            }
            this.cleanupThread = null;
            this.cleanupThread = new Thread("EventsAPI:subscribersCleanupThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (Thread.currentThread() == EventsAPI.this.cleanupThread) {
                            try {
                                Thread.sleep(60000L);
                                for (Subscriber subscriber : EventsAPI.this.subscribers) {
                                    if (subscriber.isAlive() && !subscriber.isExpired() || !EventsAPI.this.subscribers.remove(subscriber)) continue;
                                    subscriber.kill();
                                    subscriber.notifyListener();
                                    try {
                                        EventsAPI.this.localEventSender.fireEvent(new LocalEventsAPIEvent(EventsAPI.this, LocalEventsAPIEvent.Type.CHANNEL_CLOSED, subscriber));
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                                Object object = EventsAPI.this.subscribersCleanupLock;
                                synchronized (object) {
                                    if (EventsAPI.this.subscribers.size() == 0) {
                                        EventsAPI.this.cleanupThread = null;
                                        break;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    finally {
                        Object object = EventsAPI.this.subscribersCleanupLock;
                        synchronized (object) {
                            if (Thread.currentThread() == EventsAPI.this.cleanupThread) {
                                EventsAPI.this.cleanupThread = null;
                            }
                        }
                    }
                }
            };
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }
    }

    public synchronized boolean unregister(EventPublisher publisher) {
        if (publisher == null) {
            throw new NullPointerException();
        }
        boolean removed = this.publishers.remove(publisher);
        publisher.unregister(this);
        return removed;
    }

    @Override
    public SubscriptionResponse unsubscribe(long subscriptionid) {
        Subscriber subscriber = this.getSubscriber(subscriptionid);
        if (subscriber != null && this.subscribers.remove(subscriber)) {
            subscriber.kill();
            subscriber.notifyListener();
            try {
                this.localEventSender.fireEvent(new LocalEventsAPIEvent(this, LocalEventsAPIEvent.Type.CHANNEL_CLOSED, subscriber));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new SubscriptionResponse(subscriber);
        }
        return new SubscriptionResponse();
    }

    public static final String getEventID(EventObject eventObject) {
        if (eventObject != null && eventObject.getEventid() != null) {
            return eventObject.getPublisher().getPublisherName().concat(".").concat(eventObject.getEventid());
        }
        return null;
    }

    public boolean push(Subscriber subscriber, EventObject eventObject) {
        if (subscriber.isAlive() && subscriber.isSubscribed(eventObject)) {
            subscriber.push(eventObject);
            subscriber.notifyListener();
            return true;
        }
        return false;
    }

    public boolean push(Subscriber subscriber, String eventID, EventObject eventObject) {
        if (subscriber.isAlive() && subscriber.isSubscribed(eventID)) {
            subscriber.push(eventObject);
            subscriber.notifyListener();
            return true;
        }
        return false;
    }

    public void push(Subscriber subscriber, List<EventObject> events) {
        if (subscriber.isAlive()) {
            boolean notify = false;
            for (EventObject event : events) {
                if (!subscriber.isSubscribed(event)) continue;
                notify = true;
                subscriber.push(event);
            }
            if (notify) {
                subscriber.notifyListener();
            }
        }
    }

    public void push(Subscriber subscriber, String eventID, List<EventObject> events) {
        if (subscriber.isAlive()) {
            boolean notify = false;
            for (EventObject event : events) {
                if (!subscriber.isSubscribed(eventID)) continue;
                notify = true;
                subscriber.push(event);
            }
            if (notify) {
                subscriber.notifyListener();
            }
        }
    }
}

