/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.utils.Application;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.responses.HttpResponseInterface;

public class RemoteAPIResponse
implements HttpResponseInterface {
    protected final int MAXUNCOMPRESSED = Short.MAX_VALUE;
    private final HttpResponse response;
    private final RemoteAPI remoteAPI;

    public String toString() {
        return super.toString();
    }

    public RemoteAPIResponse(HttpResponse response, RemoteAPI remoteAPI) {
        this.response = response;
        this.remoteAPI = remoteAPI;
    }

    @Override
    public void closeConnection() {
        this.response.closeConnection();
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public OutputStream getOutputStream(boolean sendResponseHeaders) throws IOException {
        return this.response.getOutputStream(sendResponseHeaders);
    }

    public RemoteAPI getRemoteAPI() {
        return this.remoteAPI;
    }

    @Override
    public ResponseCodeInterface getResponseCode() {
        return this.response.getResponseCode();
    }

    @Override
    public HeaderCollection getResponseHeaders() {
        return this.response.getResponseHeaders();
    }

    public void sendBytes(RemoteAPIRequest request, byte[] bytes) throws IOException {
        if (this.getResponseHeaders().get("Cache-Control") == null) {
            this.getResponseHeaders().add(new HTTPHeader("Cache-Control", "no-store, no-cache"));
        }
        if (this.getResponseHeaders().get("Content-Type") == null) {
            this.getResponseHeaders().add(new HTTPHeader("Content-Type", "application/json"));
        }
        boolean gzip = RemoteAPI.gzip(request);
        boolean deflate = RemoteAPI.gzip(request) && Application.getJavaVersion() >= Application.JAVA16;
        boolean isHeadRequest = RemoteAPIRequest.REQUESTTYPE.HEAD.equals((Object)request.getRequestType());
        if (!gzip && !deflate || bytes.length <= this.MAXUNCOMPRESSED) {
            this.getResponseHeaders().add(new HTTPHeader("Content-Length", bytes.length + ""));
            OutputStream os = this.getOutputStream(true);
            if (!isHeadRequest) {
                os.write(bytes);
            }
        } else if (deflate) {
            this.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "deflate"));
            this.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
            OutputStream os = this.getOutputStream(true);
            if (!isHeadRequest) {
                ChunkedOutputStream cos = new ChunkedOutputStream(os);
                DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)cos, new Deflater(9, true));
                out.write(bytes);
                out.finish();
                out.flush();
                cos.sendEOF();
            }
        } else {
            this.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
            this.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
            OutputStream os = this.getOutputStream(true);
            if (!isHeadRequest) {
                ChunkedOutputStream cos = new ChunkedOutputStream(os);
                GZIPOutputStream out = new GZIPOutputStream(cos);
                out.write(bytes);
                out.finish();
                out.flush();
                cos.sendEOF();
            }
        }
    }

    @Override
    public void setResponseCode(ResponseCodeInterface responseCode) {
        this.response.setResponseCode(responseCode);
    }
}

