/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.appwork.remoteapi.InterfaceHandlerSetter;
import org.appwork.remoteapi.ParseException;
import org.appwork.remoteapi.RemoteAPIInterface;
import org.appwork.remoteapi.RemoteAPIMethodDefinition;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.RemoteAPISignatureHandler;
import org.appwork.remoteapi.annotations.AllowResponseAccess;
import org.appwork.remoteapi.annotations.ApiAuthLevel;
import org.appwork.remoteapi.annotations.ApiDoNotExpose;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.remoteapi.annotations.ApiHiddenMethod;
import org.appwork.remoteapi.annotations.ApiMethodName;
import org.appwork.remoteapi.annotations.ApiNamespace;
import org.appwork.remoteapi.annotations.ApiRawMethod;
import org.appwork.remoteapi.annotations.ApiSessionRequired;
import org.appwork.remoteapi.annotations.ApiSignatureRequired;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;

public class InterfaceHandler<T> {
    private static final String REGEX_CLS = "[a-zA-Z0-9\\[\\]_\\.]+(:?<[\\.a-zA-Z0-9\\[\\]_\\?\\,\\s<>]*>)?[\\[\\]]*";
    private final RemoteAPIInterface impl;
    private final List<Class<T>> interfaceClasses;
    private final HashMap<Method, Integer> parameterCountMap;
    private final HashMap<Method, Integer> methodsAuthLevel;
    private final HashMap<String, Method> methods;
    private final HashSet<Method> signatureRequiredMethods;
    private Method signatureHandler = null;
    private final int defaultAuthLevel;
    private boolean sessionRequired = false;
    private final String namespace;

    public static <T extends RemoteAPIInterface> InterfaceHandler<T> create(Class<T> c, RemoteAPIInterface x, int defaultAuthLevel) throws ParseException, SecurityException, NoSuchMethodException {
        InterfaceHandler<T> ret = new InterfaceHandler<T>(c, x, defaultAuthLevel);
        ret.parse();
        return ret;
    }

    public RemoteAPIInterface getImpl() {
        return this.impl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public InterfaceHandler(Class<T> c, RemoteAPIInterface x, int defaultAuthLevel) throws SecurityException, NoSuchMethodException {
        this.interfaceClasses = new ArrayList<Class<T>>();
        this.interfaceClasses.add(c);
        ApiNamespace an = c.getAnnotation(ApiNamespace.class);
        this.namespace = an == null ? c.getName() : an.value();
        this.impl = x;
        this.defaultAuthLevel = defaultAuthLevel;
        this.methodsAuthLevel = new HashMap();
        this.parameterCountMap = new HashMap();
        this.methods = new HashMap();
        this.signatureRequiredMethods = new HashSet();
        if (x instanceof InterfaceHandlerSetter) {
            ((InterfaceHandlerSetter)((Object)x)).setInterfaceHandler(this);
        }
    }

    protected InterfaceHandler() {
        this.impl = null;
        this.defaultAuthLevel = -1;
        this.namespace = null;
        this.methodsAuthLevel = new HashMap();
        this.methods = new HashMap();
        this.interfaceClasses = new ArrayList<Class<T>>();
        this.signatureRequiredMethods = new HashSet();
        this.parameterCountMap = new HashMap();
    }

    public void add(Class<T> c, RemoteAPIInterface process, int defaultAuthLevel) throws ParseException {
        if (this.sessionRequired != (c.getAnnotation(ApiSessionRequired.class) != null)) {
            throw new ParseException("Check SessionRequired for " + this);
        }
        if (defaultAuthLevel != this.getDefaultAuthLevel()) {
            throw new ParseException("Check Authlevel " + c + " " + this);
        }
        if (process != this.impl) {
            throw new ParseException(process + "!=" + this.impl);
        }
        try {
            this.interfaceClasses.add(c);
            this.parse();
        }
        catch (ParseException e) {
            this.interfaceClasses.remove(c);
            this.parse();
            throw e;
        }
    }

    public List<Class<T>> getInterfaceClasses() {
        return new ArrayList<Class<T>>(this.interfaceClasses);
    }

    public int getAuthLevel(Method m) {
        Integer auth = this.methodsAuthLevel.get(m);
        if (auth != null) {
            return auth;
        }
        return this.defaultAuthLevel;
    }

    public int getDefaultAuthLevel() {
        return this.defaultAuthLevel;
    }

    public Method getMethod(String methodName, int length) {
        String methodID = methodName + length;
        Method ret = this.methods.get(methodID);
        if (ret != null) {
            return ret;
        }
        return this.methods.get(methodName);
    }

    public boolean hasMethodName(String methodName) {
        if (StringUtils.isNotEmpty(methodName)) {
            for (String method : this.methods.keySet()) {
                if (!method.equals(methodName) && !method.matches("^" + Pattern.quote(methodName) + "\\d+$")) continue;
                return true;
            }
        }
        return false;
    }

    public int getParameterCount(Method method) {
        Integer ret = this.parameterCountMap.get(method);
        if (ret != null) {
            return ret;
        }
        return -1;
    }

    public Method getSignatureHandler() {
        return this.signatureHandler;
    }

    private String helpJSON(RemoteAPIRequest request, RemoteAPIResponse response) throws UnsupportedEncodingException, IOException {
        ArrayList<RemoteAPIMethodDefinition> methodDefinitions = new ArrayList<RemoteAPIMethodDefinition>();
        for (Method m : this.methods.values()) {
            RemoteAPIMethodDefinition mDef = new RemoteAPIMethodDefinition();
            mDef.setMethodName(m.getName());
            ApiDoc an = m.getAnnotation(ApiDoc.class);
            if (an != null) {
                mDef.setDescription(an.value());
            }
            ArrayList<String> parameters = new ArrayList<String>();
            for (int i = 0; i < m.getGenericParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i] == RemoteAPIRequest.class || m.getParameterTypes()[i] == RemoteAPIResponse.class) continue;
                parameters.add(m.getParameterTypes()[i].getSimpleName());
            }
            mDef.setParameters(parameters);
            methodDefinitions.add(mDef);
        }
        return JSonStorage.serializeToJson(methodDefinitions);
    }

    public Object invoke(Method method, Object[] parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (method.getDeclaringClass() == InterfaceHandler.class) {
            return method.invoke((Object)this, parameters);
        }
        return method.invoke((Object)this.impl, parameters);
    }

    public boolean isSessionRequired() {
        return this.sessionRequired;
    }

    public boolean isSignatureRequired(Method m) {
        return this.signatureRequiredMethods.contains(m);
    }

    public void parse() throws ParseException {
        this.methods.clear();
        this.parameterCountMap.clear();
        this.methodsAuthLevel.clear();
        this.signatureHandler = null;
        Class<T> signatureHandlerNeededClass = null;
        for (Class<T> interfaceClass : this.interfaceClasses) {
            for (Method m : interfaceClass.getMethods()) {
                ApiSignatureRequired signature;
                if (m.getAnnotation(ApiHiddenMethod.class) != null || m.getAnnotation(ApiDoNotExpose.class) != null) continue;
                int paramCounter = 0;
                for (Class<?> c : m.getParameterTypes()) {
                    if (c == RemoteAPIRequest.class || c == RemoteAPIResponse.class) continue;
                    ++paramCounter;
                }
                String name = m.getName();
                if ("handleRemoteAPISignature".equals(name) && paramCounter == 0) {
                    this.signatureHandler = m;
                    continue;
                }
                ApiMethodName methodname = m.getAnnotation(ApiMethodName.class);
                if (methodname != null) {
                    name = methodname.value();
                }
                if (this.methods.put(name + paramCounter, m) != null) {
                    throw new ParseException(interfaceClass + " already contains method: \r\n" + name + "\r\n");
                }
                if (m.getAnnotation(ApiRawMethod.class) != null) {
                    Method existing = this.methods.get(name);
                    if (existing == null) {
                        this.methods.put(name, m);
                    } else {
                        int existingParamCounter = 0;
                        boolean hasRemoteAPIRequest = false;
                        for (Class<?> c : existing.getParameterTypes()) {
                            if (c == RemoteAPIRequest.class) {
                                hasRemoteAPIRequest = true;
                            }
                            if (c == RemoteAPIRequest.class || c == RemoteAPIResponse.class) continue;
                            ++existingParamCounter;
                        }
                        if (hasRemoteAPIRequest && paramCounter < existingParamCounter) {
                            this.methods.put(name, m);
                        }
                    }
                }
                this.parameterCountMap.put(m, paramCounter);
                ApiAuthLevel auth = m.getAnnotation(ApiAuthLevel.class);
                if (auth != null) {
                    this.methodsAuthLevel.put(m, auth.value());
                }
                if ((signature = m.getAnnotation(ApiSignatureRequired.class)) == null) continue;
                signatureHandlerNeededClass = interfaceClass;
                this.signatureRequiredMethods.add(m);
            }
        }
        if (signatureHandlerNeededClass != null && this.signatureHandler == null) {
            throw new ParseException(signatureHandlerNeededClass + " Contains methods that need validated Signatures but no Validator provided");
        }
    }

    public void registerExtraMethod(String string, Method m) {
        this.methods.put("help", m);
        this.parameterCountMap.put(m, 0);
        this.methodsAuthLevel.put(m, 0);
    }

    protected void setSessionRequired(boolean sessionRequired) throws ParseException {
        this.sessionRequired = sessionRequired;
    }

    private void validateMethod(Method m) throws ParseException {
        if ("help".equalsIgnoreCase(m.getName())) {
            throw new ParseException(m + " is reserved for internal usage");
        }
        boolean responseIsParamater = false;
        for (Type t : m.getGenericParameterTypes()) {
            if (RemoteAPIRequest.class == t || RemoteAPIResponse.class != t || m.getAnnotation(AllowResponseAccess.class) != null) continue;
            responseIsParamater = true;
        }
        if (responseIsParamater) {
            if (m.getGenericReturnType() != Void.TYPE && m.getGenericReturnType() != Void.class && !RemoteAPISignatureHandler.class.isAssignableFrom(m.getDeclaringClass())) {
                throw new ParseException("Response in Parameters. " + m + " must return void, and has to handle the response itself");
            }
        } else if (m.getGenericReturnType() == Void.TYPE || m.getGenericReturnType() == Void.class) {
            return;
        }
    }

    protected File getSourceFile(Class cls) {
        URL url2 = Application.getRessourceURL("");
        try {
            File bin = new File(url2.toURI());
            File ws = bin.getParentFile().getParentFile();
            for (File project : ws.listFiles()) {
                File file;
                if (!project.isDirectory() || !(file = new File(project, "src/" + cls.getName().replace(".", "/") + ".java")).exists()) continue;
                return file;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Method> getMethodsMap() {
        InterfaceHandler interfaceHandler = this;
        synchronized (interfaceHandler) {
            return new HashMap<String, Method>(this.methods);
        }
    }
}

