/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.appwork.propertystate.Manager;
import org.appwork.propertystate.PropertyCompareHelper;
import org.appwork.propertystate.PropertyState;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;

public class SinglePropertyStateImpl
implements PropertyState {
    private final String key;
    private final Object value;
    private final Manager manager;

    public Object getValue() {
        return this.value;
    }

    public SinglePropertyStateImpl(Manager manager, String key, Object value) {
        this.manager = manager;
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Object get(String key) {
        if (key.equals(this.key)) {
            return this.value;
        }
        return null;
    }

    @Override
    public boolean wouldEqualAfterModification(PropertyState currentState, String name, Object arg) {
        return PropertyCompareHelper.wouldEqualAfterModification(this, currentState, name, arg);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean containsKey(Object name) {
        return this.key.equals(name);
    }

    public String toString() {
        return "SingleState\r\n" + this.key + "=" + this.value;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(this.key, this.value);
        return ret;
    }

    @Override
    public boolean equalsMap(Map<String, Object> map) {
        if (map.containsKey("_") ? this.size() != 2 : map.size() != 1) {
            return false;
        }
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if ("_".equals(e.getKey())) continue;
            return this.key.equals(e.getKey()) && CompareUtils.equalsDeep(e.getValue(), this.value);
        }
        return false;
    }

    @Override
    public <T> T get(String key, Type target, T defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object ret = this.get(key);
        return (T)ReflectionUtils.cast(ret, target);
    }

    @Override
    public boolean wouldEqualAfterRemoval(PropertyState currentState, String name) {
        return PropertyCompareHelper.wouldEqualAfterRemoval(this, currentState, name);
    }

    @Override
    public Collection<String> keySet() {
        return Arrays.asList(this.key);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }
}

