/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appwork.propertystate.PropertyState;
import org.appwork.propertystate.PropertyStateIndexCache;

public class PropertyStateIndexCacheImpl
implements PropertyStateIndexCache {
    private ArrayList<PropertyState> indexList = new ArrayList();

    @Override
    public Map<String, Object> toMap(PropertyState state) {
        int nextFreeIndex = -1;
        for (int i = 0; i < this.indexList.size(); ++i) {
            PropertyState other = this.indexList.get(i);
            if (other == state) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("_", i);
                return ret;
            }
            if (other != null || nextFreeIndex >= 0) continue;
            nextFreeIndex = i;
        }
        if (nextFreeIndex >= 0) {
            this.indexList.set(nextFreeIndex, state);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.putAll(state.toMap());
            ret.put("_", nextFreeIndex);
            return ret;
        }
        this.indexList.add(state);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.putAll(state.toMap());
        ret.put("_", this.indexList.size() - 1);
        return ret;
    }

    @Override
    public PropertyState getState(int index) {
        if (this.indexList != null && this.indexList.size() > index) {
            return this.indexList.get(index);
        }
        return null;
    }

    @Override
    public void put(int index, PropertyState found) {
        while (this.indexList.size() < index) {
            this.indexList.add(null);
        }
        if (this.indexList.size() == index) {
            this.indexList.add(found);
        } else {
            this.indexList.set(index, found);
        }
    }
}

