/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import org.appwork.propertystate.PropertyState;
import org.appwork.utils.CompareUtils;

public class PropertyCompareHelper {
    public static boolean wouldEqualAfterRemoval(PropertyState mayMatch, PropertyState compareTo, String toRemove) {
        int requiredSize = compareTo.size();
        if (mayMatch.size() < requiredSize - 1) {
            return false;
        }
        if (mayMatch.size() > requiredSize) {
            return false;
        }
        if (compareTo.containsKey(toRemove)) {
            --requiredSize;
        }
        if (mayMatch.size() != requiredSize) {
            return false;
        }
        if (mayMatch.containsKey(toRemove)) {
            return false;
        }
        for (String key : mayMatch.keySet()) {
            if (!compareTo.containsKey(key)) {
                return false;
            }
            if (CompareUtils.equalsDeep(mayMatch.get(key), compareTo.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean wouldEqualAfterModification(PropertyState mayMatch, PropertyState compareTo, String modifiedKey, Object newValue) {
        int requiredSize = compareTo.size();
        if (mayMatch.size() < requiredSize) {
            return false;
        }
        if (mayMatch.size() > requiredSize + 1) {
            return false;
        }
        if (!compareTo.containsKey(modifiedKey)) {
            ++requiredSize;
        }
        if (mayMatch.size() != requiredSize) {
            return false;
        }
        if (!mayMatch.containsKey(modifiedKey)) {
            return false;
        }
        if (!CompareUtils.equalsDeep(mayMatch.get(modifiedKey), newValue)) {
            return false;
        }
        for (String key : mayMatch.keySet()) {
            if (modifiedKey.equals(key)) continue;
            if (!compareTo.containsKey(key)) {
                return false;
            }
            if (CompareUtils.equalsDeep(mayMatch.get(key), compareTo.get(key))) continue;
            return false;
        }
        return true;
    }
}

