/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.moment;

import java.util.Calendar;
import java.util.Date;
import org.appwork.exceptions.WTFException;
import org.appwork.moment.UnitsTime;

public class Moment {
    private Calendar c = Calendar.getInstance();
    private long timestamp;

    public Moment(long time) {
        this.timestamp = time;
        this.c.setTimeInMillis(time);
    }

    public Moment(Date cur) {
        this(cur.getTime());
    }

    public Moment() {
        this(System.currentTimeMillis());
    }

    public Moment map(int amount, UnitsTime interval) {
        this.timestamp = this.getMappedTimestamp(amount, interval);
        return this;
    }

    public String toString() {
        return new Date(this.timestamp).toString();
    }

    public long getMappedTimestamp(int amount, UnitsTime interval) {
        this.c.setTimeInMillis(this.timestamp);
        switch (interval) {
            case SECOND: {
                this.c.set(14, 0);
                this.c.set(13, amount * (this.c.get(13) / amount));
                return this.c.getTimeInMillis();
            }
            case MINUTE: {
                this.c.set(14, 0);
                this.c.set(13, 0);
                this.c.set(12, amount * (this.c.get(12) / amount));
                return this.c.getTimeInMillis();
            }
            case HOUR: {
                this.c.set(14, 0);
                this.c.set(13, 0);
                this.c.set(12, 0);
                this.c.set(11, amount * (this.c.get(11) / amount));
                return this.c.getTimeInMillis();
            }
            case DAY: {
                this.c.set(14, 0);
                this.c.set(13, 0);
                this.c.set(12, 0);
                this.c.set(11, 0);
                this.c.set(5, amount * (this.c.get(5) / amount));
                return this.c.getTimeInMillis();
            }
            case MONTH: {
                this.c.set(14, 0);
                this.c.set(13, 0);
                this.c.set(12, 0);
                this.c.set(11, 0);
                this.c.set(5, 1);
                this.c.set(2, amount * (this.c.get(2) / amount));
                return this.c.getTimeInMillis();
            }
            case YEAR: {
                this.c.set(14, 0);
                this.c.set(13, 0);
                this.c.set(12, 0);
                this.c.set(11, 0);
                this.c.set(5, 1);
                this.c.set(2, 0);
                this.c.set(1, amount * (this.c.get(1) / amount));
                return this.c.getTimeInMillis();
            }
        }
        throw new WTFException("Not Supported: " + (Object)((Object)interval));
    }

    public Moment add(int i, UnitsTime month) {
        this.c.setTimeInMillis(this.timestamp);
        this.c.add(month.calendarID, i);
        this.timestamp = this.c.getTimeInMillis();
        return this;
    }

    public long getTimeInMS() {
        return this.timestamp;
    }

    public Date toDate() {
        return new Date(this.timestamp);
    }

    public void setTimeInMS(long time) {
        this.timestamp = time;
    }

    public int getHourOfDay() {
        this.c.setTimeInMillis(this.timestamp);
        return this.c.get(11);
    }

    public int getDayOfWeek() {
        this.c.setTimeInMillis(this.timestamp);
        return this.c.get(7);
    }
}

