/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.LogV3Factory;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.LogVetoListener;
import org.appwork.loggingv3.simple.LoggerToSink;
import org.appwork.loggingv3.simple.SinkProvider;
import org.appwork.loggingv3.simple.sink.LogToFileSink;
import org.appwork.loggingv3.simple.sink.LogToStdOutSink;
import org.appwork.loggingv3.simple.sink.Sink;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.reflection.Clazz;

public class SimpleLoggerFactory
implements LogV3Factory,
SinkProvider {
    protected final CopyOnWriteArrayList<Sink> sinks = new CopyOnWriteArrayList();
    protected final HashMap<String, LoggerToSink> logger = new HashMap();
    protected LogToFileSink sinkToFile;
    protected LogToStdOutSink sinkToConsole;
    private volatile HashSet<LogVetoListener> vetoListener;

    public List<Sink> getSinks() {
        return Collections.unmodifiableList(this.sinks);
    }

    public LogToFileSink getSinkToFile() {
        return this.sinkToFile;
    }

    public void setSinkToFile(LogToFileSink sinkToFile) {
        this.removeSink(this.sinkToFile);
        this.sinkToFile = sinkToFile;
        this.addSink(sinkToFile);
    }

    public LogToStdOutSink getSinkToConsole() {
        return this.sinkToConsole;
    }

    public void setSinkToConsole(LogToStdOutSink sinkToConsole) {
        this.removeSink(this.sinkToConsole);
        this.sinkToConsole = sinkToConsole;
        this.addSink(sinkToConsole);
    }

    public void initDefaults() {
        this.sinkToConsole = new LogToStdOutSink();
        this.addSink(this.sinkToConsole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogInterface getLogger(Object name) {
        if (name == null) {
            return this.getDefaultLogger();
        }
        HashMap<String, LoggerToSink> hashMap = this.logger;
        synchronized (hashMap) {
            String id = name.toString();
            LoggerToSink ret = this.logger.get(id);
            if (ret == null) {
                ret = this.createLogger(name);
                this.logger.put(id, ret);
            }
            return ret;
        }
    }

    protected LoggerToSink createLogger(Object name) {
        return new LoggerToSink(this);
    }

    @Override
    public LogInterface getDefaultLogger() {
        return this.getLogger(LogV3.class.getSimpleName());
    }

    public boolean addSink(Sink sink) {
        return sink != null && this.sinks.addIfAbsent(sink);
    }

    public boolean removeSink(Sink sink) {
        return sink != null && this.sinks.remove(sink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVetoListener(LogVetoListener logVetoListener) {
        SimpleLoggerFactory simpleLoggerFactory = this;
        synchronized (simpleLoggerFactory) {
            if (logVetoListener != null) {
                HashSet<LogVetoListener> newList = new HashSet<LogVetoListener>();
                if (this.vetoListener != null) {
                    newList.addAll(this.vetoListener);
                }
                boolean ret = newList.add(logVetoListener);
                this.vetoListener = newList;
                return ret;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVetoListener(LogVetoListener logVetoListener) {
        SimpleLoggerFactory simpleLoggerFactory = this;
        synchronized (simpleLoggerFactory) {
            if (this.vetoListener != null && logVetoListener != null) {
                HashSet<LogVetoListener> newList = new HashSet<LogVetoListener>();
                newList.addAll(this.vetoListener);
                boolean ret = newList.remove(logVetoListener);
                this.vetoListener = newList.size() == 0 ? null : newList;
                return ret;
            }
            return false;
        }
    }

    @Override
    public void publish(LogRecord2 record) {
        HashSet<LogVetoListener> vetoListener = this.vetoListener;
        block0: for (Sink sink : this.sinks) {
            if (vetoListener != null) {
                for (LogVetoListener veto : vetoListener) {
                    if (!veto.blockLogPublishing(this, sink, record)) continue;
                    continue block0;
                }
            }
            sink.publish(record);
        }
    }

    @Override
    public SimpleLoggerFactory setFactory(LogV3Factory previousFactory) {
        return this;
    }

    public boolean hasSink(Sink sink) {
        return sink != null && this.sinks.contains(sink);
    }

    public <T extends Sink> T getSinkByClass(Class<T> class1) {
        for (Sink sink : this.sinks) {
            if (!Clazz.isInstanceof(sink.getClass(), class1)) continue;
            return (T)sink;
        }
        return null;
    }
}

