/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.DebugMode;
import org.appwork.utils.logging2.LogInterface;

public abstract class AbstractLogger
implements LogInterface {
    protected StackTraceElement getThrownAt() {
        Exception e = new Exception();
        StackTraceElement last = null;
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement es;
            last = es = stackTraceElementArray[i];
            if (this.filterThrownAtEntries(es)) continue;
            return es;
        }
        return last;
    }

    protected boolean filterThrownAtEntries(StackTraceElement es) {
        if (es.getClassName().startsWith(DebugMode.class.getName())) {
            if ("logInfoInIDEOnly".equals(es.getMethodName())) {
                return true;
            }
            if ("logInIDEOnly".equals(es.getMethodName())) {
                return true;
            }
            if ("debugger".equals(es.getMethodName())) {
                return true;
            }
            if ("breakIf".equals(es.getMethodName())) {
                return true;
            }
            if ("TRIGGER_BUILD_ERROR".equals(es.getMethodName())) {
                return true;
            }
            new Exception("Extend Log Formater here to show the correct logging source").printStackTrace();
        }
        if (es.getClassName().startsWith(LogV3.class.getPackage().getName()) || es.getClassName().startsWith("org.slf4j.") || es.getClassName().contains("Logger") || es.getClassName().contains("logging")) {
            return true;
        }
        return es.getMethodName().equals("log") || es.getMethodName().equals("info") || es.getMethodName().equals("messageLogged") || es.getMethodName().equals("fireMessageLoggedEvent") || es.getMethodName().equals("fireMessageLogged") || es.getMethodName().contains("Logger") || es.getMethodName().contains("logger");
    }

    @Override
    public void log(Throwable e) {
        this.info(AbstractLogger.getStackTrace(e));
    }

    public static String getStackTrace(Throwable thrown) {
        if (thrown == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    @Override
    public void fine(String msg) {
        this.info(msg);
    }

    @Override
    public void finest(String msg) {
        this.info(msg);
    }

    @Override
    public void severe(String msg) {
        this.info(msg);
    }

    @Override
    public void finer(String msg) {
        this.info(msg);
    }

    @Override
    public void warning(String msg) {
        this.info(msg);
    }

    @Override
    public void exception(String msg, Throwable e) {
        this.info(msg + "\r\n" + AbstractLogger.getStackTrace(e));
    }
}

