/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.unixsplit.tests;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.appwork.io.unixsplit.StreamProvider;
import org.appwork.io.unixsplit.UnixSplitInputStream;
import org.appwork.io.unixsplit.UnixSplitOutputStream;
import org.appwork.utils.Application;
import org.appwork.utils.IO;

public class UnixSplitTest2 {
    public static void main(String[] args) throws IOException {
        Application.setApplication(".tests");
        UnixSplitTest2.extracted(500000, 10000000);
        UnixSplitTest2.extracted(1, 300);
    }

    protected static void extracted(final int chunkSize, int totalSize) throws IOException {
        final File root = Application.getResource("");
        root.mkdirs();
        for (File f : root.listFiles()) {
            if (!f.getName().matches("^test.txt.[a-z]{2,}$")) continue;
            f.delete();
        }
        UnixSplitOutputStream stream = new UnixSplitOutputStream(new StreamProvider(){

            @Override
            public StreamProvider.PartInfo getNextStream(int i) throws IOException {
                File file = new File(root, "test.txt." + UnixSplitInputStream.buildSegment(i, 5));
                return new StreamProvider.PartInfo(new FileOutputStream(file), chunkSize);
            }
        });
        BufferedOutputStream buffered = new BufferedOutputStream(stream);
        for (int i = 0; i < totalSize; ++i) {
            buffered.write(97 + i % 10);
        }
        buffered.close();
        UnixSplitInputStream in = new UnixSplitInputStream(new File(root, "test.txt.aaaaa"));
        byte[] bytes = IO.readStream(-1, in);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 97 + i % 10) continue;
            throw new IOException("Unexpected content");
        }
        in.close();
        for (File f : root.listFiles()) {
            if (!f.getName().matches("^test.txt.[a-z]{2,}$")) continue;
            f.delete();
        }
        System.out.println("SUCCESS " + stream.getPartCount());
    }
}

