/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.streams.signature.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.exceptions.WTFException;
import org.appwork.io.streams.signature.DigestInterface;
import org.appwork.io.streams.signature.HandleStreamSignatureInputStream;
import org.appwork.io.streams.signature.MacDigester;
import org.appwork.io.streams.signature.MessageDigester;
import org.appwork.io.streams.signature.SignatureMismatchException;
import org.appwork.io.streams.signature.StreamEndedUnexpectedException;
import org.appwork.io.streams.signature.StreamSignatureCreatingOutputStream;
import org.appwork.utils.IO;

public class SignatureStreamTest {
    private static final byte[] B = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static StreamSignatureCreatingOutputStream out;
    private static ByteArrayOutputStream baos;
    private static byte[] rawInput;
    private static byte[] bytes;
    private static byte[] nonce;
    private static int chunkLength;
    private static DigestInterface digester;
    private static MacDigester macDigester;

    public static void main(String[] args) throws Exception {
        digester = new MessageDigester(MessageDigest.getInstance("SHA-256"));
        SecretKeySpec secretKeySpec = new SecretKeySpec("ABC".getBytes(), "SHA-256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secretKeySpec);
        macDigester = new MacDigester(mac);
        SignatureStreamTest.testReadExactContentLength();
        SignatureStreamTest.testIncrementRead();
        SignatureStreamTest.testSslMacEOFCutStreamMD5();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                try {
                    mac = Mac.getInstance(service.getAlgorithm());
                    mac.init(secretKeySpec);
                    macDigester = new MacDigester(mac);
                    digester = macDigester;
                    try {
                        mac.clone();
                        SignatureStreamTest.testIncompleteStreamClonableMAC();
                    }
                    catch (CloneNotSupportedException e) {
                        SignatureStreamTest.testIncompleteStreamNotCloneable();
                    }
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (InvalidKeyException e) {
                    // empty catch block
                }
                try {
                    digester = new MessageDigester(MessageDigest.getInstance(service.getAlgorithm()));
                    try {
                        mac.clone();
                        SignatureStreamTest.testIncompleteStreamClonableMAC();
                    }
                    catch (CloneNotSupportedException e) {
                        SignatureStreamTest.testIncompleteStreamNotCloneable();
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (InvalidKeyException invalidKeyException) {}
            }
        }
        SignatureStreamTest.testReadUntilEOF();
        SignatureStreamTest.testReadToEndOfChunk();
        SignatureStreamTest.testCorruptStream();
        SignatureStreamTest.testReadPlus1Scenario();
        SignatureStreamTest.testEmptyStream();
    }

    private static void testIncrementRead() {
    }

    protected static void testIncompleteStreamClonableMAC() throws Exception {
        SignatureStreamTest.write(null, 100, 1024, digester);
        byte[] bytesTmp = new byte[102 + digester.getLength()];
        System.arraycopy(bytes, 0, bytesTmp, 0, bytesTmp.length);
        bytes = bytesTmp;
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        try {
            IO.readStream(-1, in);
            throw new Exception("Expected StreamEndedUnexpectedException here");
        }
        catch (StreamEndedUnexpectedException e) {
            if (in.getLastValidPayloadPosition() != (long)chunkLength) {
                throw new Exception("Validation not correct");
            }
            if (in.getPayloadBytesLoaded() != (long)chunkLength) {
                throw new Exception("Payload bytes read incorrect");
            }
            if (!in.isClosed()) {
                throw new Exception("STream should be closed");
            }
            System.out.println("TEST testIncompleteStream " + digester + ": SUCCESS");
        }
        catch (SignatureMismatchException e) {
            e.printStackTrace();
            System.out.println("The Digester " + digester + " does not support Cloning");
        }
    }

    protected static void testSslMacEOFCutStreamMD5() throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec("ABC".getBytes(), "SHA-256");
        Mac mac = Mac.getInstance("SslMacMD5");
        mac.init(secretKeySpec);
        SignatureStreamTest.write(null, 100, 1024, new MacDigester(mac));
        byte[] bytesTmp = new byte[134];
        System.arraycopy(bytes, 0, bytesTmp, 0, bytesTmp.length);
        bytes = bytesTmp;
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        try {
            IO.readStream(-1, in);
            throw new Exception("Expected StreamEndedUnexpectedException here");
        }
        catch (EOFException e) {
            if (in.getLastValidPayloadPosition() != (long)chunkLength) {
                throw new Exception("Validation not correct");
            }
            if (in.getPayloadBytesLoaded() != (long)chunkLength) {
                throw new Exception("Payload bytes read incorrect");
            }
            if (!in.isClosed()) {
                throw new Exception("STream should be closed");
            }
            System.out.println("TEST testSslMacMD5: SUCCESS");
            return;
        }
    }

    protected static void testIncompleteStreamNotCloneable() throws Exception {
        SignatureStreamTest.write(null, 100, 1024, digester);
        byte[] bytesTmp = new byte[102 + digester.getLength()];
        System.arraycopy(bytes, 0, bytesTmp, 0, bytesTmp.length);
        bytes = bytesTmp;
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        try {
            IO.readStream(-1, in);
            throw new Exception("Expected StreamEndedUnexpectedException here");
        }
        catch (StreamEndedUnexpectedException e) {
            System.out.println("The Digester " + digester + " does not support Cloning and should not throw this exception");
            e.printStackTrace();
        }
        catch (SignatureMismatchException e) {
            if (in.getLastValidPayloadPosition() != 0L) {
                throw new Exception("Validation not correct");
            }
            if (in.getPayloadBytesLoaded() != (long)chunkLength) {
                throw new Exception("Payload bytes read incorrect");
            }
            if (!in.isClosed()) {
                throw new Exception("STream should be closed");
            }
            System.out.println("The Digester " + digester + " does not support Cloning");
            System.out.println("TEST testIncompleteStream " + digester + ": SUCCESS");
        }
    }

    protected static void testEmptyStream() throws Exception {
        SignatureStreamTest.write(nonce, chunkLength, 0, digester);
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        IO.readStream(-1, in);
        if (in.getLastValidPayloadPosition() != (long)rawInput.length) {
            throw new Exception("Validation not correct");
        }
        if (in.getPayloadBytesLoaded() != (long)rawInput.length) {
            throw new Exception("Payload bytes read incorrect");
        }
        if (!in.isClosed()) {
            throw new Exception("STream should be closed");
        }
        System.out.println("TEST Empty STream: SUCCESS");
    }

    protected static void testReadPlus1Scenario() throws Exception {
        SignatureStreamTest.write(null, 10, 3, digester);
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        IO.readStream(3, in);
        if (in.getLastValidPayloadPosition() != (long)rawInput.length) {
            throw new Exception("Validation not correct");
        }
        if (in.getPayloadBytesLoaded() != (long)rawInput.length) {
            throw new Exception("Payload bytes read incorrect");
        }
        if (!in.isClosed()) {
            throw new Exception("STream should be closed");
        }
        System.out.println("TEST +1 scenario: SUCCESS");
    }

    protected static void write(byte[] nonce, int chunkLength, int byteCount, DigestInterface digester) throws IOException {
        SignatureStreamTest.nonce = nonce;
        if (chunkLength > 0) {
            SignatureStreamTest.chunkLength = chunkLength;
        }
        if (digester != null) {
            SignatureStreamTest.digester = digester;
        }
        ByteArrayOutputStream rawBaos = new ByteArrayOutputStream();
        baos = new ByteArrayOutputStream();
        out = new StreamSignatureCreatingOutputStream((OutputStream)baos, digester, nonce, chunkLength);
        while (byteCount > 0) {
            out.write(B, 0, Math.min(byteCount, B.length));
            rawBaos.write(B, 0, Math.min(byteCount, B.length));
            byteCount -= Math.min(byteCount, B.length);
        }
        rawInput = rawBaos.toByteArray();
        out.close();
        bytes = baos.toByteArray();
        int expectedBytes = rawInput.length;
        int x = IO.writeLongOptimized(out.getStreamVersion(), null);
        expectedBytes += x;
        expectedBytes = (int)((double)expectedBytes + Math.max(1.0, Math.ceil((double)rawInput.length / (double)chunkLength)) * (double)(digester.getLength() + IO.writeLongOptimized(chunkLength, null)));
        if (bytes.length != expectedBytes) {
            throw new WTFException("We expected a stream size of " + expectedBytes);
        }
        if ((long)bytes.length != out.getRawBytesWritten()) {
            throw new WTFException("We expected a stream size of " + expectedBytes);
        }
    }

    protected static void testCorruptStream() throws NoSuchAlgorithmException, IOException {
        SignatureStreamTest.write(null, 9, 1024, new MessageDigester(MessageDigest.getInstance("SHA-256")));
        try {
            bytes[0] = (byte)(bytes[0] + 1);
            HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
            IO.readStream(rawInput.length, in);
            throw new Exception("This should have bannged");
        }
        catch (Exception e) {
            bytes[0] = (byte)(bytes[0] - 1);
            System.out.println("TEST detect bad first byte: SUCCESS");
            try {
                int n = bytes.length / 2;
                bytes[n] = (byte)(bytes[n] + 1);
                HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
                IO.readStream(rawInput.length, in);
                throw new Exception("This should have bannged");
            }
            catch (Exception e2) {
                int n = bytes.length / 2;
                bytes[n] = (byte)(bytes[n] - 1);
                System.out.println("TEST detect bad middle byte: SUCCESS");
                try {
                    int n2 = bytes.length - 1;
                    bytes[n2] = (byte)(bytes[n2] + 1);
                    HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
                    byte[] readBytes = IO.readStream(rawInput.length, in);
                    throw new Exception("This should have bannged");
                }
                catch (Exception e3) {
                    int n3 = bytes.length - 1;
                    bytes[n3] = (byte)(bytes[n3] - 1);
                    System.out.println("TEST detect last byte: SUCCESS");
                    return;
                }
            }
        }
    }

    protected static void testReadToEndOfChunk() throws Exception {
        SignatureStreamTest.write(null, 9, 1024, new MessageDigester(MessageDigest.getInstance("SHA-256")));
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        byte[] readBytes = IO.readStream(chunkLength, in);
        if (in.getLastValidPayloadPosition() != in.getPayloadBytesLoaded()) {
            throw new WTFException("Not fully validated");
        }
        if (!in.isClosed()) {
            throw new Exception("STream should be closed");
        }
        if (in.getLastValidPayloadPosition() != (long)chunkLength) {
            throw new Exception("Validation not correct");
        }
        if (in.getPayloadBytesLoaded() != (long)chunkLength) {
            throw new Exception("Payload bytes read incorrect");
        }
        System.out.println("TEST Reading exact to end of chunk: SUCCESS");
    }

    protected static void testReadExactContentLength() throws Exception {
        SignatureStreamTest.write(null, 9, 1024, new MessageDigester(MessageDigest.getInstance("SHA-256")));
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce);
        byte[] readBytes = IO.readStream(rawInput.length, in);
        if (!Arrays.equals(readBytes, rawInput)) {
            throw new WTFException("COntent Mismatch");
        }
        if (in.getLastValidPayloadPosition() != in.getPayloadBytesLoaded()) {
            throw new WTFException("Not fully validated");
        }
        if (in.getLastValidPayloadPosition() != (long)rawInput.length) {
            throw new Exception("Validation not correct");
        }
        if (in.getPayloadBytesLoaded() != (long)rawInput.length) {
            throw new Exception("Payload bytes read incorrect");
        }
        if (!in.isClosed()) {
            throw new Exception("STream should be closed");
        }
        System.out.println("TEST Reading to end of chunvk: SUCCESS");
    }

    protected static void testReadUntilEOF() throws Exception {
        SignatureStreamTest.write(null, 9, 1024, new MessageDigester(MessageDigest.getInstance("SHA-256")));
        HandleStreamSignatureInputStream in = new HandleStreamSignatureInputStream((InputStream)new ByteArrayInputStream(bytes), digester, nonce){

            @Override
            protected long readNextPayloadBlockSize() throws IOException {
                long ret = super.readNextPayloadBlockSize();
                if (ret != (long)chunkLength) {
                    throw new IOException("bad Chunksize read");
                }
                return ret;
            }
        };
        in.read(new byte[0]);
        if (in.getStreamVersion() != 1L) {
            throw new WTFException("Bad StreamVersion");
        }
        byte[] buffer = new byte[10];
        try {
            do {
                new DataInputStream(in).readFully(buffer);
            } while (Arrays.equals(buffer, B));
            throw new Exception("Content MissMatch");
        }
        catch (EOFException e) {
            if (in.getLastValidPayloadPosition() != (long)rawInput.length) {
                throw new Exception("Validation not correct");
            }
            if (in.getPayloadBytesLoaded() != (long)rawInput.length) {
                throw new Exception("Payload bytes read incorrect");
            }
            if (in.getLastValidPayloadPosition() != in.getPayloadBytesLoaded()) {
                throw new WTFException("Not fully validated");
            }
            if (!in.isClosed()) {
                throw new Exception("STream should be closed");
            }
            System.out.println("TEST Reading until -1: SUCCESS");
            return;
        }
    }

    static {
        nonce = null;
    }
}

