/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.streams.signature;

import javax.crypto.Mac;
import org.appwork.io.streams.signature.DigestInterface;

public class MacDigester
implements DigestInterface {
    private final Mac mac;

    public MacDigester(Mac mac) {
        this.mac = mac;
    }

    public String toString() {
        return this.getLength() + "b " + this.mac.getAlgorithm();
    }

    @Override
    public void update(byte[] b) {
        this.mac.update(b);
    }

    @Override
    public void update(byte b) {
        this.mac.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.mac.update(b, off, len);
    }

    @Override
    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    @Override
    public int getLength() {
        return this.mac.getMacLength();
    }

    @Override
    public MacDigester clone() throws CloneNotSupportedException {
        Mac interna = (Mac)this.mac.clone();
        return new MacDigester(interna);
    }

    @Override
    public boolean supportsCloning() {
        return this.mac instanceof Cloneable;
    }
}

