/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.csv;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.appwork.utils.StringUtils;

public class CSVBuilder {
    private String seperator;
    private final ArrayList<Entry> entries = new ArrayList();
    private Entry current;
    private final LinkedHashMap<String, Integer> headers;
    private final LinkedHashMap<Integer, Integer> width;
    private Character headerLineCharacter = Character.valueOf('-');
    public static final SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY HH:mm", Locale.GERMAN);
    private final HashSet<String> hides = new HashSet();

    public String getSeperator() {
        return this.seperator;
    }

    public void setSeperator(String seperator) {
        this.seperator = seperator;
    }

    public Character getHeaderLineCharacter() {
        return this.headerLineCharacter;
    }

    public void setHeaderLineCharacter(Character headerLineCharacter) {
        this.headerLineCharacter = headerLineCharacter;
    }

    public CSVBuilder(String trenn) {
        this.seperator = trenn;
        this.headers = new LinkedHashMap();
        this.width = new LinkedHashMap();
    }

    public void next() {
        this.current = new Entry();
        this.entries.add(this.current);
    }

    public String toString() {
        String ret = "";
        int i = 0;
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Integer> es : this.headers.entrySet()) {
            keys.add(es.getKey());
            if (this.hides.contains(es.getKey())) continue;
            if (ret.length() > 0) {
                ret = ret + this.seperator;
            }
            ret = this.getAlignRight(es.getKey()) ? ret + StringUtils.fillPre(es.getKey(), " ", this.width.get(i)) : ret + StringUtils.fillPost(es.getKey(), " ", this.width.get(i));
            ++i;
        }
        ret = ret + "\r\n";
        if (this.headerLineCharacter != null) {
            String line = StringUtils.fillPost("", "" + this.headerLineCharacter, ret.length() - 2);
            ret = ret + line;
            ret = line + "\r\n" + ret;
        }
        for (Entry e : this.entries) {
            ret = ret + "\r\n";
            for (i = 0; i < Math.max(this.headers.size(), e.size()); ++i) {
                String key = (String)keys.get(i);
                if (this.hides.contains(key)) continue;
                if (i > 0) {
                    ret = ret + this.seperator;
                }
                if (e.size() > i) {
                    if (this.getAlignRight(key)) {
                        ret = ret + StringUtils.fillPre((String)e.get(i), " ", this.width.get(i));
                        continue;
                    }
                    ret = ret + StringUtils.fillPost((String)e.get(i), " ", this.width.get(i));
                    continue;
                }
                ret = ret + "";
            }
        }
        return ret;
    }

    protected boolean getAlignRight(String string) {
        if (string.endsWith("InEUR")) {
            return true;
        }
        return string.endsWith("InDays");
    }

    public void add(String key, String format) {
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, this.headers.size());
        }
        int index = this.headers.get(key);
        while (this.current.size() - 1 < index) {
            this.current.add("");
        }
        Integer w = this.width.get(index);
        int max = Math.max(format.length(), key.length());
        if (w == null || w < max) {
            this.width.put(index, max);
        }
        this.current.set(index, format);
    }

    public void add(String key, int gewinn) {
        this.add(key, "" + gewinn);
    }

    public void add(String key, double gewinn) {
        this.add(key, (gewinn + "").replace(".", ","));
    }

    public void add(String key, Date date) {
        this.add(key, df.format(date));
    }

    public void hide(String ... headers) {
        this.hides.addAll(Arrays.asList(headers));
    }

    public class Entry
    extends ArrayList<String> {
    }
}

