/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.app.launcher.parameterparser;

import java.util.ArrayList;
import java.util.List;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.utils.locale._AWU;

public abstract class CommandLineApp {
    private final String[] commands;
    private String description;
    private final List<String[]> parameters;

    public CommandLineApp(String ... commands) {
        this.commands = commands;
        this.parameters = new ArrayList<String[]>();
    }

    public void addParameter(String name, String description) {
        this.parameters.add(new String[]{name, description});
    }

    public abstract void execute(CommandSwitch var1);

    public String[] getCommands() {
        return this.commands;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String[]> getParameters() {
        return this.parameters;
    }

    public void onEmptyCommand(CommandSwitch event) {
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_AWU.T.COMMANDLINEAPP_COMMAND());
        for (int i = 0; i < this.commands.length; ++i) {
            sb.append(this.commands[i]);
            if (i >= this.commands.length - 1) continue;
            sb.append(" / ");
        }
        sb.append(" | ").append(this.getDescription());
        sb.append("\r\n");
        for (String[] parameter : this.parameters) {
            sb.append("    ").append(parameter[0]).append(" | ").append(parameter[1]).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

