/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.app.gui.copycutpaste;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.appwork.app.gui.copycutpaste.ContextMenuAdapter;
import org.appwork.app.gui.copycutpaste.CopyAction;
import org.appwork.app.gui.copycutpaste.CutAction;
import org.appwork.app.gui.copycutpaste.DeleteAction;
import org.appwork.app.gui.copycutpaste.PasteAction;
import org.appwork.app.gui.copycutpaste.SelectAction;

public class CopyPasteSupport
implements AWTEventListener {
    private long startupTime = System.currentTimeMillis();
    private long lastMouseEvent = -1L;

    public long getStartupTime() {
        return this.startupTime;
    }

    public long getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        JPopupMenu menu;
        Component c;
        if (!(event instanceof MouseEvent)) {
            return;
        }
        this.lastMouseEvent = System.currentTimeMillis();
        MouseEvent mouseEvent = (MouseEvent)event;
        if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 3) {
            return;
        }
        if (mouseEvent.getComponent() == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() instanceof JDialog) {
            c = SwingUtilities.getDeepestComponentAt((JDialog)mouseEvent.getSource(), (int)point.getX(), (int)point.getY());
        } else if (mouseEvent.getSource() instanceof JFrame) {
            Container source = ((JFrame)mouseEvent.getSource()).getContentPane();
            point.x -= source.getLocationOnScreen().x - ((JFrame)mouseEvent.getSource()).getLocationOnScreen().x;
            point.y -= source.getLocationOnScreen().y - ((JFrame)mouseEvent.getSource()).getLocationOnScreen().y;
            c = SwingUtilities.getDeepestComponentAt(source, (int)point.getX(), (int)point.getY());
        } else if (mouseEvent.getSource() instanceof Component) {
            c = (Component)mouseEvent.getSource();
        } else {
            return;
        }
        if (!(c instanceof JTextComponent) && !(c instanceof ContextMenuAdapter)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        JTextComponent t = (JTextComponent)c;
        t.requestFocus();
        if (c instanceof ContextMenuAdapter) {
            menu = ((ContextMenuAdapter)((Object)c)).getPopupMenu(mouseEvent, this.createCutAction(t), this.createCopyAction(t), this.createPasteAction(t), this.createDeleteAction(t), this.createSelectAction(t));
            if (menu == null) {
                return;
            }
        } else {
            menu = new JPopupMenu();
            menu.add(this.createCutAction(t));
            menu.add(this.createCopyAction(t));
            menu.add(this.createPasteAction(t));
            menu.add(this.createDeleteAction(t));
            menu.add(this.createSelectAction(t));
        }
        Point pt = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), c);
        menu.show(c, pt.x, pt.y);
    }

    protected AbstractAction createSelectAction(JTextComponent t) {
        return new SelectAction(t);
    }

    protected AbstractAction createDeleteAction(JTextComponent t) {
        return new DeleteAction(t);
    }

    protected AbstractAction createPasteAction(JTextComponent t) {
        return new PasteAction(t);
    }

    protected AbstractAction createCopyAction(JTextComponent t) {
        return new CopyAction(t);
    }

    protected AbstractAction createCutAction(JTextComponent t) {
        return new CutAction(t);
    }

    public static void ensure() {
        for (AWTEventListener l : Toolkit.getDefaultToolkit().getAWTEventListeners()) {
            if (!(l instanceof CopyPasteSupport)) continue;
            return;
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new CopyPasteSupport(), 16L);
    }
}

