/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.app.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.appwork.app.gui.ActiveDialogException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.swing.ExtJFrame;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dimensor.RememberLastDimensor;
import org.appwork.utils.swing.locator.RememberAbsoluteLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;

public abstract class BasicGui {
    private final JFrame frame;
    private RememberAbsoluteLocator locator;
    private RememberLastDimensor dimensor;

    public static void main(String[] args) {
        try {
            for (int i = 2; i >= 0; --i) {
                Thread.sleep(1000L);
                System.out.println(i);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                BasicGui bg = new BasicGui("Test"){

                    @Override
                    protected void layoutPanel() {
                        final ExtButton bt = new ExtButton(new BasicAction(" button"){
                            private static final long serialVersionUID = -4007724735998967065L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            for (int i = 2; i >= 0; --i) {
                                                Thread.sleep(1000L);
                                                System.out.println(i);
                                            }
                                            this.getFrame().setAlwaysOnTop(false);
                                            WindowManager.getInstance().setZState(this.getFrame(), WindowManager.FrameState.TO_FRONT_FOCUSED);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }.start();
                            }
                        });
                        this.getFrame().add(bt);
                        this.getFrame().addWindowFocusListener(new WindowFocusListener(){

                            @Override
                            public void windowGainedFocus(WindowEvent windowevent) {
                                bt.setText("JIPPIE! I Got Focused");
                            }

                            @Override
                            public void windowLostFocus(WindowEvent windowevent) {
                                bt.setText(" :( No Focus para mi");
                            }
                        });
                    }

                    @Override
                    protected void requestExit() {
                        ShutdownController.getInstance().requestShutdown();
                    }
                };
            }
        };
        try {
            Thread.sleep(1000000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected BasicGui(String title) {
        this.frame = new ExtJFrame(title){
            private static final long serialVersionUID = -8325715174242107194L;

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    for (Window w : this.getOwnedWindows()) {
                        if (!(w instanceof JDialog) || !((JDialog)w).isModal() || !w.isActive()) continue;
                        UIManager.getLookAndFeel().provideErrorFeedback(this);
                        throw new ActiveDialogException((JDialog)w);
                    }
                    BasicGui.this.locator.onClose(BasicGui.this.frame, null);
                    BasicGui.this.dimensor.onClose(BasicGui.this.frame, null);
                }
                super.setVisible(b);
            }

            private void superPack() {
                super.pack();
            }

            @Override
            public void pack() {
                this.superPack();
                if (CrossSystem.isLinux()) {
                    SwingUtils.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.superPack();
                        }
                    }, 100);
                }
            }

            @Override
            public void toFront() {
                super.toFront();
            }
        };
        this.locator = new RememberAbsoluteLocator(null);
        this.dimensor = new RememberLastDimensor(null);
        AbstractDialog.setDefaultRoot(this.frame);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                BasicGui.this.locator.onClose(BasicGui.this.frame, arg0);
                BasicGui.this.dimensor.onClose(BasicGui.this.frame, arg0);
                if (!CrossSystem.isMac()) {
                    new Thread("Closer"){

                        @Override
                        public void run() {
                            BasicGui.this.requestExit();
                        }
                    }.start();
                } else if (BasicGui.this.getFrame().isVisible()) {
                    WindowManager.getInstance().setVisible(BasicGui.this.getFrame(), false);
                }
            }
        });
        this.frame.setDefaultCloseOperation(0);
        this.frame.setIconImages(this.getAppIconList());
        this.frame.setMinimumSize(new Dimension(100, 100));
        Dimension dim = this.dimensor.getDimension(this.frame);
        if (dim != null) {
            this.frame.setPreferredSize(dim);
        }
        this.layoutPanel();
        this.frame.pack();
        Point loc = this.locator.getLocationOnScreen(this.frame);
        if (loc != null) {
            this.frame.setLocation(loc);
        }
        WindowManager.getInstance().setVisible(this.frame, true);
        WindowManager.getInstance().show(this.frame, WindowManager.FrameState.TO_FRONT_FOCUSED);
    }

    public void dispose() {
        WindowManager.getInstance().setVisible(this.frame, false);
        this.frame.dispose();
    }

    protected List<? extends Image> getAppIconList() {
        ArrayList list = new ArrayList();
        return list;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    protected abstract void layoutPanel();

    protected abstract void requestExit();
}

