/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.util;

import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.fixed.FixedSocksSelector;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import com.btr.proxy.util.Logger;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ProxyUtil {
    public static final int DEFAULT_PROXY_PORT = 80;
    private static List<Proxy> noProxyList;

    public static FixedProxySelector parseProxySettings(String proxyVar) {
        if (proxyVar == null || proxyVar.trim().length() == 0) {
            return null;
        }
        try {
            String protocol;
            if (proxyVar.indexOf(":/") == -1) {
                proxyVar = "http://" + proxyVar;
            }
            URI url = new URI(proxyVar);
            String host = ProxyUtil.cleanIPv6(url.getHost());
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            if ((protocol = url.getScheme().toLowerCase(Locale.ENGLISH)).startsWith("socks")) {
                return new FixedSocksSelector(host.trim(), port);
            }
            return new FixedProxySelector(host.trim(), port);
        }
        catch (URISyntaxException e) {
            Logger.log(ProxyUtil.class, Logger.LogLevel.WARNING, "Cannot parse Proxy Settings {0}", proxyVar);
            return null;
        }
    }

    public static synchronized List<Proxy> noProxyList() {
        if (noProxyList == null) {
            ArrayList<Proxy> list = new ArrayList<Proxy>(1);
            list.add(Proxy.NO_PROXY);
            noProxyList = Collections.unmodifiableList(list);
        }
        return noProxyList;
    }

    public static PacProxySelector buildPacSelectorForUrl(String url) {
        PacProxySelector result = null;
        UrlPacScriptSource pacSource = new UrlPacScriptSource(url);
        if (pacSource.isScriptValid()) {
            result = new PacProxySelector(pacSource);
        }
        return result;
    }

    public static String cleanIPv6(String hostOrIP) {
        if (hostOrIP == null) {
            return null;
        }
        if ((hostOrIP = hostOrIP.trim()).startsWith("[")) {
            hostOrIP = hostOrIP.substring(1);
        }
        if (hostOrIP.endsWith("]")) {
            hostOrIP = hostOrIP.substring(0, hostOrIP.length() - 1);
        }
        return hostOrIP;
    }
}

