/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.selector.whitelist.DefaultWhiteListParser;
import com.btr.proxy.util.ProxyUtil;
import com.btr.proxy.util.UriFilter;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;

public class UseProxyWhiteListSelector
extends ProxySelector {
    private ProxySelector delegate;
    private List<UriFilter> whiteListFilter;

    public UseProxyWhiteListSelector(String whiteList, ProxySelector proxySelector) {
        if (whiteList == null) {
            throw new NullPointerException("Whitelist must not be null.");
        }
        if (proxySelector == null) {
            throw new NullPointerException("ProxySelector must not be null.");
        }
        this.delegate = proxySelector;
        DefaultWhiteListParser parser = new DefaultWhiteListParser();
        this.whiteListFilter = parser.parseWhiteList(whiteList);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.delegate.connectFailed(uri, sa, ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        for (UriFilter filter : this.whiteListFilter) {
            if (!filter.accept(uri)) continue;
            return this.delegate.select(uri);
        }
        return ProxyUtil.noProxyList();
    }
}

